package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.Billing;
import com.xforceplus.arterydocument.service.IBillingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-09
 */
@RestController
public class BillingController {

  @Autowired
  private IBillingService billingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billing ${table.comment}
   * @return
   */
  @GetMapping("/billings" )
  public XfR getBillings(XfPage page, Billing billing) {
    return XfR.ok(billingServiceImpl.page(page, Wrappers.query(billing)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billing ${table.comment}
   * @return XfR
   */
  @PostMapping("/billings")
  public XfR save(@RequestBody Billing billing) {
     return XfR.ok(billingServiceImpl.save(billing));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billing ${table.comment}
   * @return XfR
   */
  @PutMapping("/billings/{id}")
  public XfR putUpdate(@RequestBody Billing billing,@PathVariable Long id) {
      billing.setId(id);
      return XfR.ok(billingServiceImpl.updateById(billing));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billing ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billings/{id}")
  public XfR patchUpdate(@RequestBody Billing billing,@PathVariable Long id) {
      Billing upbilling = billingServiceImpl.getById(id);
      if(upbilling != null){
        upbilling = ObjectCopyUtils.copyProperties(billing,upbilling,true);
      }
      return XfR.ok(billingServiceImpl.updateById(upbilling));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billingServiceImpl.removeById(id));
  }

  @PostMapping("/billings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "billing");
     params.put("request", condition);

     return XfR.ok(billingServiceImpl.querys(params));
  }

}
