package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PurchaseOrgs;
import com.xforceplus.arterydocument.service.IPurchaseOrgsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-01
 */
@RestController
public class PurchaseOrgsController {

  @Autowired
  private IPurchaseOrgsService purchaseOrgsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseOrgs ${table.comment}
   * @return
   */
  @GetMapping("/purchaseorgss" )
  public XfR getPurchaseOrgss(XfPage page, PurchaseOrgs purchaseOrgs) {
    return XfR.ok(purchaseOrgsServiceImpl.page(page, Wrappers.query(purchaseOrgs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseorgss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseOrgsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseOrgs ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseorgss")
  public XfR save(@RequestBody PurchaseOrgs purchaseOrgs) {
     return XfR.ok(purchaseOrgsServiceImpl.save(purchaseOrgs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseOrgs ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseorgss/{id}")
  public XfR putUpdate(@RequestBody PurchaseOrgs purchaseOrgs,@PathVariable Long id) {
      purchaseOrgs.setId(id);
      return XfR.ok(purchaseOrgsServiceImpl.updateById(purchaseOrgs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseOrgs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseorgss/{id}")
  public XfR patchUpdate(@RequestBody PurchaseOrgs purchaseOrgs,@PathVariable Long id) {
      PurchaseOrgs uppurchaseOrgs = purchaseOrgsServiceImpl.getById(id);
      if(uppurchaseOrgs != null){
        uppurchaseOrgs = ObjectCopyUtils.copyProperties(purchaseOrgs,uppurchaseOrgs,true);
      }
      return XfR.ok(purchaseOrgsServiceImpl.updateById(uppurchaseOrgs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseorgss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseOrgsServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseorgss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_orgs");
     params.put("request", condition);

     return XfR.ok(purchaseOrgsServiceImpl.querys(params));
  }

}
