package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.StandardDataCollection;
import com.xforceplus.arterydocument.service.IStandardDataCollectionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-01
 */
@RestController
public class StandardDataCollectionController {

  @Autowired
  private IStandardDataCollectionService standardDataCollectionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param standardDataCollection ${table.comment}
   * @return
   */
  @GetMapping("/standarddatacollections" )
  public XfR getStandardDataCollections(XfPage page, StandardDataCollection standardDataCollection) {
    return XfR.ok(standardDataCollectionServiceImpl.page(page, Wrappers.query(standardDataCollection)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/standarddatacollections/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(standardDataCollectionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param standardDataCollection ${table.comment}
   * @return XfR
   */
  @PostMapping("/standarddatacollections")
  public XfR save(@RequestBody StandardDataCollection standardDataCollection) {
     return XfR.ok(standardDataCollectionServiceImpl.save(standardDataCollection));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param standardDataCollection ${table.comment}
   * @return XfR
   */
  @PutMapping("/standarddatacollections/{id}")
  public XfR putUpdate(@RequestBody StandardDataCollection standardDataCollection,@PathVariable Long id) {
      standardDataCollection.setId(id);
      return XfR.ok(standardDataCollectionServiceImpl.updateById(standardDataCollection));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param standardDataCollection ${table.comment}
   * @return XfR
   */
  @PatchMapping("/standarddatacollections/{id}")
  public XfR patchUpdate(@RequestBody StandardDataCollection standardDataCollection,@PathVariable Long id) {
      StandardDataCollection upstandardDataCollection = standardDataCollectionServiceImpl.getById(id);
      if(upstandardDataCollection != null){
        upstandardDataCollection = ObjectCopyUtils.copyProperties(standardDataCollection,upstandardDataCollection,true);
      }
      return XfR.ok(standardDataCollectionServiceImpl.updateById(upstandardDataCollection));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/standarddatacollections/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(standardDataCollectionServiceImpl.removeById(id));
  }

  @PostMapping("/standarddatacollections/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "standard_data_collection");
     params.put("request", condition);

     return XfR.ok(standardDataCollectionServiceImpl.querys(params));
  }

}
