package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PosAndIrDataIssue;
import com.xforceplus.arterydocument.service.IPosAndIrDataIssueService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-01-28
 */
@RestController
public class PosAndIrDataIssueController {

  @Autowired
  private IPosAndIrDataIssueService posAndIrDataIssueServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posAndIrDataIssue ${table.comment}
   * @return
   */
  @GetMapping("/posandirdataissues" )
  public XfR getPosAndIrDataIssues(XfPage page, PosAndIrDataIssue posAndIrDataIssue) {
    return XfR.ok(posAndIrDataIssueServiceImpl.page(page, Wrappers.query(posAndIrDataIssue)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/posandirdataissues/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posAndIrDataIssueServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param posAndIrDataIssue ${table.comment}
   * @return XfR
   */
  @PostMapping("/posandirdataissues")
  public XfR save(@RequestBody PosAndIrDataIssue posAndIrDataIssue) {
     return XfR.ok(posAndIrDataIssueServiceImpl.save(posAndIrDataIssue));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param posAndIrDataIssue ${table.comment}
   * @return XfR
   */
  @PutMapping("/posandirdataissues/{id}")
  public XfR putUpdate(@RequestBody PosAndIrDataIssue posAndIrDataIssue,@PathVariable Long id) {
      posAndIrDataIssue.setId(id);
      return XfR.ok(posAndIrDataIssueServiceImpl.updateById(posAndIrDataIssue));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param posAndIrDataIssue ${table.comment}
   * @return XfR
   */
  @PatchMapping("/posandirdataissues/{id}")
  public XfR patchUpdate(@RequestBody PosAndIrDataIssue posAndIrDataIssue,@PathVariable Long id) {
      PosAndIrDataIssue upposAndIrDataIssue = posAndIrDataIssueServiceImpl.getById(id);
      if(upposAndIrDataIssue != null){
        upposAndIrDataIssue = ObjectCopyUtils.copyProperties(posAndIrDataIssue,upposAndIrDataIssue,true);
      }
      return XfR.ok(posAndIrDataIssueServiceImpl.updateById(upposAndIrDataIssue));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/posandirdataissues/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posAndIrDataIssueServiceImpl.removeById(id));
  }

  @PostMapping("/posandirdataissues/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_and_ir_data_issue");
     params.put("request", condition);

     return XfR.ok(posAndIrDataIssueServiceImpl.querys(params));
  }

}
