package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PaymentDetail;
import com.xforceplus.arterydocument.service.IPaymentDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class PaymentDetailController {

  @Autowired
  private IPaymentDetailService paymentDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param paymentDetail ${table.comment}
   * @return
   */
  @GetMapping("/paymentdetails" )
  public XfR getPaymentDetails(XfPage page, PaymentDetail paymentDetail) {
    return XfR.ok(paymentDetailServiceImpl.page(page, Wrappers.query(paymentDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/paymentdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(paymentDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param paymentDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/paymentdetails")
  public XfR save(@RequestBody PaymentDetail paymentDetail) {
     return XfR.ok(paymentDetailServiceImpl.save(paymentDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param paymentDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/paymentdetails/{id}")
  public XfR putUpdate(@RequestBody PaymentDetail paymentDetail,@PathVariable Long id) {
      paymentDetail.setId(id);
      return XfR.ok(paymentDetailServiceImpl.updateById(paymentDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param paymentDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/paymentdetails/{id}")
  public XfR patchUpdate(@RequestBody PaymentDetail paymentDetail,@PathVariable Long id) {
      PaymentDetail uppaymentDetail = paymentDetailServiceImpl.getById(id);
      if(uppaymentDetail != null){
        uppaymentDetail = ObjectCopyUtils.copyProperties(paymentDetail,uppaymentDetail,true);
      }
      return XfR.ok(paymentDetailServiceImpl.updateById(uppaymentDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/paymentdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(paymentDetailServiceImpl.removeById(id));
  }

  @PostMapping("/paymentdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "payment_detail");
     params.put("request", condition);

     return XfR.ok(paymentDetailServiceImpl.querys(params));
  }

}
