package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PosAndIrTransferHeader;
import com.xforceplus.arterydocument.service.IPosAndIrTransferHeaderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class PosAndIrTransferHeaderController {

  @Autowired
  private IPosAndIrTransferHeaderService posAndIrTransferHeaderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posAndIrTransferHeader ${table.comment}
   * @return
   */
  @GetMapping("/posandirtransferheaders" )
  public XfR getPosAndIrTransferHeaders(XfPage page, PosAndIrTransferHeader posAndIrTransferHeader) {
    return XfR.ok(posAndIrTransferHeaderServiceImpl.page(page, Wrappers.query(posAndIrTransferHeader)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/posandirtransferheaders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posAndIrTransferHeaderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param posAndIrTransferHeader ${table.comment}
   * @return XfR
   */
  @PostMapping("/posandirtransferheaders")
  public XfR save(@RequestBody PosAndIrTransferHeader posAndIrTransferHeader) {
     return XfR.ok(posAndIrTransferHeaderServiceImpl.save(posAndIrTransferHeader));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param posAndIrTransferHeader ${table.comment}
   * @return XfR
   */
  @PutMapping("/posandirtransferheaders/{id}")
  public XfR putUpdate(@RequestBody PosAndIrTransferHeader posAndIrTransferHeader,@PathVariable Long id) {
      posAndIrTransferHeader.setId(id);
      return XfR.ok(posAndIrTransferHeaderServiceImpl.updateById(posAndIrTransferHeader));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param posAndIrTransferHeader ${table.comment}
   * @return XfR
   */
  @PatchMapping("/posandirtransferheaders/{id}")
  public XfR patchUpdate(@RequestBody PosAndIrTransferHeader posAndIrTransferHeader,@PathVariable Long id) {
      PosAndIrTransferHeader upposAndIrTransferHeader = posAndIrTransferHeaderServiceImpl.getById(id);
      if(upposAndIrTransferHeader != null){
        upposAndIrTransferHeader = ObjectCopyUtils.copyProperties(posAndIrTransferHeader,upposAndIrTransferHeader,true);
      }
      return XfR.ok(posAndIrTransferHeaderServiceImpl.updateById(upposAndIrTransferHeader));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/posandirtransferheaders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posAndIrTransferHeaderServiceImpl.removeById(id));
  }

  @PostMapping("/posandirtransferheaders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_and_ir_transfer_header");
     params.put("request", condition);

     return XfR.ok(posAndIrTransferHeaderServiceImpl.querys(params));
  }

}
