package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementInvoiceDetail;
import com.xforceplus.arterydocument.service.ISettlementInvoiceDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-19
 */
@RestController
public class SettlementInvoiceDetailController {

  @Autowired
  private ISettlementInvoiceDetailService settlementInvoiceDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementInvoiceDetail ${table.comment}
   * @return
   */
  @GetMapping("/settlementinvoicedetails" )
  public XfR getSettlementInvoiceDetails(XfPage page, SettlementInvoiceDetail settlementInvoiceDetail) {
    return XfR.ok(settlementInvoiceDetailServiceImpl.page(page, Wrappers.query(settlementInvoiceDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementinvoicedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementInvoiceDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param settlementInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/settlementinvoicedetails")
  public XfR save(@RequestBody SettlementInvoiceDetail settlementInvoiceDetail) {
     return XfR.ok(settlementInvoiceDetailServiceImpl.save(settlementInvoiceDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param settlementInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/settlementinvoicedetails/{id}")
  public XfR putUpdate(@RequestBody SettlementInvoiceDetail settlementInvoiceDetail,@PathVariable Long id) {
      settlementInvoiceDetail.setId(id);
      return XfR.ok(settlementInvoiceDetailServiceImpl.updateById(settlementInvoiceDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param settlementInvoiceDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/settlementinvoicedetails/{id}")
  public XfR patchUpdate(@RequestBody SettlementInvoiceDetail settlementInvoiceDetail,@PathVariable Long id) {
      SettlementInvoiceDetail upsettlementInvoiceDetail = settlementInvoiceDetailServiceImpl.getById(id);
      if(upsettlementInvoiceDetail != null){
        upsettlementInvoiceDetail = ObjectCopyUtils.copyProperties(settlementInvoiceDetail,upsettlementInvoiceDetail,true);
      }
      return XfR.ok(settlementInvoiceDetailServiceImpl.updateById(upsettlementInvoiceDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementinvoicedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementInvoiceDetailServiceImpl.removeById(id));
  }

  @PostMapping("/settlementinvoicedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_invoice_detail");
     params.put("request", condition);

     return XfR.ok(settlementInvoiceDetailServiceImpl.querys(params));
  }

}
