package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SchemaCodeMapping;
import com.xforceplus.arterydocument.service.ISchemaCodeMappingService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-02-27
 */
@RestController
public class SchemaCodeMappingController {

  @Autowired
  private ISchemaCodeMappingService schemaCodeMappingServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param schemaCodeMapping ${table.comment}
   * @return
   */
  @GetMapping("/schemacodemappings" )
  public XfR getSchemaCodeMappings(XfPage page, SchemaCodeMapping schemaCodeMapping) {
    return XfR.ok(schemaCodeMappingServiceImpl.page(page, Wrappers.query(schemaCodeMapping)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/schemacodemappings/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(schemaCodeMappingServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param schemaCodeMapping ${table.comment}
   * @return XfR
   */
  @PostMapping("/schemacodemappings")
  public XfR save(@RequestBody SchemaCodeMapping schemaCodeMapping) {
     return XfR.ok(schemaCodeMappingServiceImpl.save(schemaCodeMapping));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param schemaCodeMapping ${table.comment}
   * @return XfR
   */
  @PutMapping("/schemacodemappings/{id}")
  public XfR putUpdate(@RequestBody SchemaCodeMapping schemaCodeMapping,@PathVariable Long id) {
      schemaCodeMapping.setId(id);
      return XfR.ok(schemaCodeMappingServiceImpl.updateById(schemaCodeMapping));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param schemaCodeMapping ${table.comment}
   * @return XfR
   */
  @PatchMapping("/schemacodemappings/{id}")
  public XfR patchUpdate(@RequestBody SchemaCodeMapping schemaCodeMapping,@PathVariable Long id) {
      SchemaCodeMapping upschemaCodeMapping = schemaCodeMappingServiceImpl.getById(id);
      if(upschemaCodeMapping != null){
        upschemaCodeMapping = ObjectCopyUtils.copyProperties(schemaCodeMapping,upschemaCodeMapping,true);
      }
      return XfR.ok(schemaCodeMappingServiceImpl.updateById(upschemaCodeMapping));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/schemacodemappings/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(schemaCodeMappingServiceImpl.removeById(id));
  }

  @PostMapping("/schemacodemappings/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "schema_code_mapping");
     params.put("request", condition);

     return XfR.ok(schemaCodeMappingServiceImpl.querys(params));
  }

}
