package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PosAndIrTransferResult;
import com.xforceplus.arterydocument.service.IPosAndIrTransferResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-03-03
 */
@RestController
public class PosAndIrTransferResultController {

  @Autowired
  private IPosAndIrTransferResultService posAndIrTransferResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param posAndIrTransferResult ${table.comment}
   * @return
   */
  @GetMapping("/posandirtransferresults" )
  public XfR getPosAndIrTransferResults(XfPage page, PosAndIrTransferResult posAndIrTransferResult) {
    return XfR.ok(posAndIrTransferResultServiceImpl.page(page, Wrappers.query(posAndIrTransferResult)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/posandirtransferresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(posAndIrTransferResultServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param posAndIrTransferResult ${table.comment}
   * @return XfR
   */
  @PostMapping("/posandirtransferresults")
  public XfR save(@RequestBody PosAndIrTransferResult posAndIrTransferResult) {
     return XfR.ok(posAndIrTransferResultServiceImpl.save(posAndIrTransferResult));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param posAndIrTransferResult ${table.comment}
   * @return XfR
   */
  @PutMapping("/posandirtransferresults/{id}")
  public XfR putUpdate(@RequestBody PosAndIrTransferResult posAndIrTransferResult,@PathVariable Long id) {
      posAndIrTransferResult.setId(id);
      return XfR.ok(posAndIrTransferResultServiceImpl.updateById(posAndIrTransferResult));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param posAndIrTransferResult ${table.comment}
   * @return XfR
   */
  @PatchMapping("/posandirtransferresults/{id}")
  public XfR patchUpdate(@RequestBody PosAndIrTransferResult posAndIrTransferResult,@PathVariable Long id) {
      PosAndIrTransferResult upposAndIrTransferResult = posAndIrTransferResultServiceImpl.getById(id);
      if(upposAndIrTransferResult != null){
        upposAndIrTransferResult = ObjectCopyUtils.copyProperties(posAndIrTransferResult,upposAndIrTransferResult,true);
      }
      return XfR.ok(posAndIrTransferResultServiceImpl.updateById(upposAndIrTransferResult));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/posandirtransferresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(posAndIrTransferResultServiceImpl.removeById(id));
  }

  @PostMapping("/posandirtransferresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pos_and_ir_transfer_result");
     params.put("request", condition);

     return XfR.ok(posAndIrTransferResultServiceImpl.querys(params));
  }

}
