package com.xforceplus.arterydocument.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.SettlementDoc;
import com.xforceplus.arterydocument.service.ISettlementDocService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * V2前端控制器
 *
 * @author ultraman
 * @date 2024-03-03
 */
@RestController
public class SettlementDocController {

  @Autowired
  private ISettlementDocService settlementDocServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param settlementDoc V2
   * @return
   */
  @GetMapping("/settlementdocs" )
  public XfR getSettlementDocs(XfPage page, SettlementDoc settlementDoc) {
    return XfR.ok(settlementDocServiceImpl.page(page, Wrappers.query(settlementDoc)));
  }

  /**
   * 通过id查询V2
   * @param  id
   * @return XfR
   */
  @GetMapping("/settlementdocs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(settlementDocServiceImpl.getById(id));
  }

  /**
   * 新增V2
   * @param settlementDoc V2
   * @return XfR
   */
  @PostMapping("/settlementdocs")
  public XfR save(@RequestBody SettlementDoc settlementDoc) {
     return XfR.ok(settlementDocServiceImpl.save(settlementDoc));
  }

  /**
   * 修改-传入修改后的全部数据V2
   * @param settlementDoc V2
   * @return XfR
   */
  @PutMapping("/settlementdocs/{id}")
  public XfR putUpdate(@RequestBody SettlementDoc settlementDoc,@PathVariable Long id) {
      settlementDoc.setId(id);
      return XfR.ok(settlementDocServiceImpl.updateById(settlementDoc));
  }

  /**
   * 修改-传入修改的数据V2
   * @param settlementDoc V2
   * @return XfR
   */
  @PatchMapping("/settlementdocs/{id}")
  public XfR patchUpdate(@RequestBody SettlementDoc settlementDoc,@PathVariable Long id) {
      SettlementDoc upsettlementDoc = settlementDocServiceImpl.getById(id);
      if(upsettlementDoc != null){
        upsettlementDoc = ObjectCopyUtils.copyProperties(settlementDoc,upsettlementDoc,true);
      }
      return XfR.ok(settlementDocServiceImpl.updateById(upsettlementDoc));
  }

  /**
   * 通过id删除V2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/settlementdocs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(settlementDocServiceImpl.removeById(id));
  }

  @PostMapping("/settlementdocs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "settlement_doc");
     params.put("request", condition);

     return XfR.ok(settlementDocServiceImpl.querys(params));
  }

}
