package com.xforceplus.autotest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.autotest.entity.Autocode1;
import com.xforceplus.autotest.service.IAutocode1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-08
 */
@RestController
public class Autocode1Controller {

  @Autowired
  private IAutocode1Service autocode1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param autocode1 ${table.comment}
   * @return
   */
  @GetMapping("/autocode1s" )
  public XfR getAutocode1s(XfPage page, Autocode1 autocode1) {
    return XfR.ok(autocode1ServiceImpl.page(page, Wrappers.query(autocode1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/autocode1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(autocode1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param autocode1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/autocode1s")
  public XfR save(@RequestBody Autocode1 autocode1) {
     return XfR.ok(autocode1ServiceImpl.save(autocode1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param autocode1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/autocode1s/{id}")
  public XfR putUpdate(@RequestBody Autocode1 autocode1,@PathVariable Long id) {
      autocode1.setId(id);
      return XfR.ok(autocode1ServiceImpl.updateById(autocode1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param autocode1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/autocode1s/{id}")
  public XfR patchUpdate(@RequestBody Autocode1 autocode1,@PathVariable Long id) {
      Autocode1 upautocode1 = autocode1ServiceImpl.getById(id);
      if(upautocode1 != null){
        upautocode1 = ObjectCopyUtils.copyProperties(autocode1,upautocode1,true);
      }
      return XfR.ok(autocode1ServiceImpl.updateById(upautocode1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/autocode1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(autocode1ServiceImpl.removeById(id));
  }

  @PostMapping("/autocode1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "autocode1");
     params.put("request", condition);

     return XfR.ok(autocode1ServiceImpl.querys(params));
  }

}
