package com.xforceplus.biassetmanagementservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-07-26
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.biassetmanagementservice.entity.AssetMapping;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "bi-asset-management-service")
public interface AssetMappingFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/assetMapping/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param assetMapping ${table.comment}
   * @return R
   */
  @PostMapping("/assetMapping/add")
  public R save(@RequestBody AssetMapping assetMapping);

  /**
   * 修改${table.comment}
   * @param assetMapping ${table.comment}
   * @return R
   */
  @PostMapping("/assetMapping/update")
  public R updateById(@RequestBody AssetMapping assetMapping);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/assetMapping/del/{id}" )
  public R removeById(@PathVariable Long id);

}