package com.xforceplus.biassetmanagementservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * product_line
 * </p>
 *
 * @author ultraman
 * @since 2024-06-03
 */
public enum ProductLine {

    _1("1", "平台研发-用户中心"),
    _2("2", "进项-4.0"),
    _3("3", "进项-2.0/3.0"),
    _4("4", "销项-4.0"),
    _5("5", "销项-2.0/3.0"),
    _6("6", "协同"),
    _7("7", "对账协同"),
    _8("8", "数据增值"),
    _9("9", "devops"),
    _10("10", "税件"),
    _11("11", "HR"),
    _12("12", "财务"),
    _13("13", "平台研发-基础服务"),
    _14("14", "平台研发-门户"),
    _15("15", "平台研发-BI"),
    _16("16", "集成二开"),
    _17("17", "SA"),
    _18("18", "平台研发-集成平台");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProductLine(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductLine fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            default:
                return null;
        }
    }
}
