package com.xforceplus.bi.datasource.client.config;

import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.utils.BiTokenKey;
import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Configuration
public class DataSourceFeignConfig {
    @Bean
    public Decoder decoder() {
        return new DataSourceServiceDecoder();
    }

    @Bean
    public RequestInterceptor headerRequestInterceptor() {
        return requestTemplate -> {
            ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder
                    .getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
//
//            // 请求公开访问数据源模块
//            boolean isOpenApi = RequestUrlUtils.isOpenApi(request.getRequestURI(), authExcludeConfig.getExclude());
//            if (isOpenApi) {
//                log.info("请求公开访问数据源模块");
//                requestTemplate.header(RequestUrlUtils.ASK_OPEN_FOR_DATASOURCE_KEY, RequestUrlUtils.ASK_OPEN_FOR_DATASOURCE_VALUE);
//                return;
//            }

            // 不能拿所有headers,会覆盖Feign的值
//            Enumeration<String> headerNames = request.getHeaderNames();
//            if (headerNames == null) {
//                return;
//            }
//
//            while (headerNames.hasMoreElements()) {
//                String name = headerNames.nextElement();
//                String values = request.getHeader(name);
//                requestTemplate.header(name, values);
//            }

            UserInfo userInfo = RequestUserContext.get();
            // 用户为空,直接去发起Feign调用,如果权限报错,让对方返回错误
            if (userInfo == null) {
                log.warn("用户为空");
                return;
            }

            // 获取tokenKey
            String tokenKey = BiTokenKey.get(request);
            if (StringUtils.isEmpty(tokenKey)) {
                log.warn("tokenKey为空");
                return;
            }

            // token key
            requestTemplate.header(BiTokenKey.BI_TOKEN_KEY, tokenKey);
            // token
            requestTemplate.header(tokenKey, userInfo.getAccessToken());
        };
    }
}
