package com.xforceplus.bi.datasource.client.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import feign.FeignException;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class DataSourceServiceDecoder implements Decoder {
    @Override
    public Object decode(Response response, Type type) throws IOException, FeignException {
        Response.Body body = response.body();
        if (body == null) {
            return null;
        }
        String className = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType) type;
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            if (actualTypeArgument != null) {
                className = actualTypeArgument.getTypeName();
            }
        }
        if (StringUtils.isEmpty(className)) {
            className = type.getTypeName();
        }
        String s = Util.toString(body.asReader());
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className);
        } catch (ClassNotFoundException e) {
        }
        Map map = JSONObject.parseObject(s, Map.class);
        boolean success = (boolean) map.get("success");
        Assert.isTrue(success, (String) map.get("msg"));

        // 处理结果
        Object result = map.get("result");

        // 如果result是枚举的名称,需要反序列化
        if (aClass != null && aClass.isEnum()) {
            String enumName = String.valueOf(result);
            for (Object enumConstant : aClass.getEnumConstants()) {
                if (enumConstant.toString().equals(enumName)) {
                    return enumConstant;
                }
            }
        }

        // 处理 JSONObject
        if (result instanceof JSONObject && aClass != null) {
            JSONObject resultObject = (JSONObject) result;
            return resultObject.toJavaObject(aClass);
        }

        // 处理 JSONArray
        if (result instanceof JSONArray && aClass != null) {
            JSONArray resultArray = (JSONArray) result;
            return resultArray.toJavaList(aClass);
        }

        return result;
    }

}
