package com.xforceplus.bi.commons.authority.usercenter.feign.client;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.bi.commons.authority.usercenter.feign.request.MsGetUserExtraInfoRequest;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.MsGetUserExtraInfoResponse;
import com.xforceplus.bi.commons.http.OkHttpInstance;
import com.xforceplus.tenantsecurity.domain.UserType;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Map;

@Slf4j
@Service
public class UserExtraInfoClientService {

    @Value("${xforce.platforms.usercenter.url}")
    private String url;

    @Autowired
    private OkHttpInstance okHttpInstance;

    public UserExtraInfoClientService() {
    }

    public MsGetUserExtraInfoResponse userExtraInfo(String token, MsGetUserExtraInfoRequest request) throws IOException {
        Map<String, String> header = Maps.newHashMap();
        header.put(UserType.USER.tokenKey(), token);
        try {
            Response response = okHttpInstance.postBodyToResponse(url + "/user/extra-info", request, header);
            ResponseBody body = response.body();
            String result = new String(body.bytes());

            // 处理http错误
            if (!response.isSuccessful()) {
                log.error(response.message() + ":" + result);
                throw new RuntimeException(response.message());
            }
            return JSONObject.parseObject(result, MsGetUserExtraInfoResponse.class);
        } catch (Throwable throwable) {
            log.error("获取用户额外信息失败", throwable);
            throw throwable;
        }
    }
}
