/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.usercenter.feign.client;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.bi.commons.authority.usercenter.feign.request.MsGetUserExtraInfoRequest;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.MsGetUserExtraInfoResponse;
import com.xforceplus.bi.commons.http.OkHttpInstance;
import com.xforceplus.tenantsecurity.domain.UserType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserExtraInfoClientService {
    private static final Logger log = LoggerFactory.getLogger(UserExtraInfoClientService.class);
    @Value(value="${xforce.platforms.usercenter.url}")
    private String url;
    @Autowired
    private OkHttpInstance okHttpInstance;

    public MsGetUserExtraInfoResponse userExtraInfo(String token, MsGetUserExtraInfoRequest request) throws IOException {
        HashMap header = Maps.newHashMap();
        header.put(UserType.USER.tokenKey(), token);
        try {
            Response response = this.okHttpInstance.postBodyToResponse(this.url + "/user/extra-info", (Object)request, (Map)header);
            ResponseBody body = response.body();
            String result = new String(body.bytes());
            if (!response.isSuccessful()) {
                log.error(response.message() + ":" + result);
                throw new RuntimeException(response.message());
            }
            return (MsGetUserExtraInfoResponse)JSONObject.parseObject((String)result, MsGetUserExtraInfoResponse.class);
        }
        catch (Throwable throwable) {
            log.error("\u83b7\u53d6\u7528\u6237\u989d\u5916\u4fe1\u606f\u5931\u8d25", throwable);
            throw throwable;
        }
    }
}

