/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import com.google.common.collect.Maps;
import com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode.ResourceCodeClient;
import com.xforceplus.bi.commons.webutils.ApplicationContextHolder;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourceCodeClientProvider
implements InitializingBean {
    private static Map<String, ResourceCodeClient> resourceCodeClientMap = Maps.newHashMap();
    @Autowired
    private ApplicationContextHolder springContextUtil;

    public void afterPropertiesSet() throws Exception {
        ResourceCodeClientProvider resourceCodeClientProvider = this;
        Map beans = resourceCodeClientProvider.springContextUtil.getApplicationContext().getBeansOfType(ResourceCodeClient.class);
        beans.values().forEach(bean -> resourceCodeClientMap.put(bean.version(), (ResourceCodeClient)bean));
    }

    public ResourceCodeClient getInstance(String version) {
        return resourceCodeClientMap.get(version.toLowerCase());
    }
}

