package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import java.util.Set;

/**
 * 资源码接口获取客户端
 *
 * @author xuejian
 * @since common1.3
 */
public interface ResourceCodeClient {
    /**
     * 资源码接口的版本
     *
     * @return 资源码接口的版本
     */
    String version();

    /**
     * 请求用户中心对应版本的资源码接口,获取返回
     *
     * @param userId 用户ID
     * @param token  请求token
     * @return 用户的资源码集合
     * @throws Exception
     */
    Set<String> fetchResources(String userId, String token) throws Exception;
}
