package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import com.google.common.collect.Maps;
import com.xforceplus.bi.commons.webutils.ApplicationContextHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * 资源码接口客户端提供者
 *
 * @author xuejian
 * @since common1.3
 */
@Component
public class ResourceCodeClientProvider implements InitializingBean {
    private static Map<String, ResourceCodeClient> resourceCodeClientMap = Maps.newHashMap();

    @Autowired
    private ApplicationContextHolder springContextUtil;

    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, ResourceCodeClient> beans = springContextUtil.getApplicationContext().getBeansOfType(ResourceCodeClient.class);
        beans.values().forEach(bean -> {
            resourceCodeClientMap.put(bean.version(), bean);
        });
    }

    /**
     * 获取资源码接口实例
     *
     * @param version
     * @return
     */
    public ResourceCodeClient getInstance(String version) {
        return resourceCodeClientMap.get(version.toLowerCase());
    }
}
