package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.authority.usercenter.feign.client.UserExtraInfoClientService;
import com.xforceplus.bi.commons.authority.usercenter.feign.request.MsGetUserExtraInfoRequest;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.ExtraInfoModel;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.MsGetUserExtraInfoResponse;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * 资源码V1版本接口
 *
 * @author xuejian
 * @since common1.3
 */
@Service
@Slf4j
public class ResourceCodeV1Client implements ResourceCodeClient {
    @Autowired
    private UserExtraInfoClientService userExtraInfoClientService;

    @Value("${xforce.platforms.usercenter.appid:100}")
    private String appid;
//
//    @Value("${xforce.platforms.usercenter.extra:true}")
//    private boolean needExtraAuth = true;

    @Override
    public String version() {
        return "v1";
    }

    @Override
    public Set<String> fetchResources(String userId, String token) throws Exception {
        MsGetUserExtraInfoRequest msGetUserExtraInfoRequest = new MsGetUserExtraInfoRequest();
        int appId = Integer.parseInt(this.appid);
        msGetUserExtraInfoRequest.setAppId(appId);
        msGetUserExtraInfoRequest.setResources(true);

        MsGetUserExtraInfoResponse msGetUserExtraInfoResponse = userExtraInfoClientService.userExtraInfo(token, msGetUserExtraInfoRequest);

        if (msGetUserExtraInfoResponse.getCode() != 1) {
            log.error("获取用户信息接口内部错误:" + msGetUserExtraInfoResponse.getMessage());
        }

        String infoJson = msGetUserExtraInfoResponse.getInfoJson();
        if (StringUtils.isEmpty(infoJson)) {
            log.info("获取用户额外信息返回为空");
            return Sets.newHashSet();
        }
        ExtraInfoModel extraInfoModel = JsonUtils.fromJson(infoJson, ExtraInfoModel.class);
        Set<String> resourceCodes = extraInfoModel.getResourceCodes();
        if (CollectionUtils.isEmpty(resourceCodes)) {
            log.warn("infoJson:" + JSON.toJSONString(msGetUserExtraInfoResponse));
        }
        log.info("获取到的权限为: {}", resourceCodes);
        return resourceCodes;
    }
}
