package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.http.OkHttpInstance;
import com.xforceplus.tenant.security.token.domain.UserType;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 资源码V2版本接口
 *
 * @author xuejian
 * @since common1.3
 */
@Service
@Slf4j
public class ResourceCodeV2Client implements ResourceCodeClient {
    /**
     * 用户中心服务地址
     */
    @Value("${xforce.platforms.usercenter.url:}")
    private String userCenterUrl;

    @Autowired
    private OkHttpInstance okHttpInstance;

    @Override
    public String version() {
        return "v2";
    }

    @Override
    public Set<String> fetchResources(String userId, String token) throws Exception {
        // 接口地址
        String url = userCenterUrl + "/api/global/v2/users/" + userId + "?extraInfo=4";
        // headers
        Map<String, String> header = Maps.newHashMap();
        header.put(UserType.USER.tokenKey(), token);
        // 请求
        Response response = okHttpInstance.getToResponse(url, null, header);
        ResponseBody body = response.body();
        String result = new String(body.bytes());
        // 处理http错误
        if (!response.isSuccessful()) {
            log.error("请求用户中心资源码V2接口失败,返回状态码为:{},返回消息为:{},返回体为:{}", response.code(), response.message(), result);
            throw new RuntimeException(response.message());
        }
        JSONObject jsonObject = JSONObject.parseObject(result);
        Object resultObject = jsonObject.get("result");
        Assert.notNull(resultObject, "资源码接口返回结果为空");
        List<String> resourceCodes = (List<String>) ((Map) resultObject).get("resourceCodes");
        return Sets.newHashSet(resourceCodes);
    }
}
