/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.usercenter.feign.decoder;

import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import io.geewit.web.utils.JsonUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class UserContextDecoder {
    private static final Logger log = LoggerFactory.getLogger(UserContextDecoder.class);
    @Value(value="${xforce.platforms.usercenter.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;
    @Value(value="${xforce.platforms.usercenter.appid:100}")
    private String appid;

    public <O extends Org<O>, R extends TokenRole, OO extends OrgDto<OO>, RR extends RoleDto> AuthorizedUser<OO, RoleDto> decode(String token, Long tenantId) {
        Map claims = JwtUtils.verifyAndDecodeToken((String)this.secret, (String)token);
        Assert.notNull((Object)claims, (String)"claims == null, \u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55");
        String encodedUserInfo = (String)claims.get("userinfo");
        String userinfo = CompressionUtils.decode((String)encodedUserInfo);
        return this.setUserInfoHolder(userinfo, token, tenantId);
    }

    private <O extends Org<O>, R extends TokenRole, OO extends OrgDto<OO>, RR extends RoleDto> AuthorizedUser<OO, RR> setUserInfoHolder(String userinfo, String token, Long tenantId) {
        log.info("token = " + token);
        TokenUser tokenUser = (TokenUser)JsonUtils.fromJson((String)userinfo, TokenUser.class);
        if (tokenUser == null) {
            log.warn("userinfo = " + userinfo);
            return null;
        }
        if (tenantId != null) {
            tokenUser.setTenantId(tenantId);
        }
        try {
            int appId = Integer.parseInt(this.appid);
            log.info("appId:" + appId);
        }
        catch (NumberFormatException var12) {
            log.warn("\u672a\u8bbe\u7f6eappid");
            return null;
        }
        tokenUser.setToken(token);
        AuthorizedUser authorizedUser = new AuthorizedUser();
        BeanUtils.copyProperties((Object)tokenUser, (Object)authorizedUser);
        return authorizedUser;
    }
}

