/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.authority.usercenter.feign.client.UserExtraInfoClientService;
import com.xforceplus.bi.commons.authority.usercenter.feign.request.MsGetUserExtraInfoRequest;
import com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode.ResourceCodeClient;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.ExtraInfoModel;
import com.xforceplus.bi.commons.authority.usercenter.feign.response.MsGetUserExtraInfoResponse;
import io.geewit.web.utils.JsonUtils;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ResourceCodeV1Client
implements ResourceCodeClient {
    private static final Logger log = LoggerFactory.getLogger(ResourceCodeV1Client.class);
    @Autowired
    private UserExtraInfoClientService userExtraInfoClientService;
    @Value(value="${xforce.platforms.usercenter.appid:100}")
    private String appid;

    @Override
    public String version() {
        return "v1";
    }

    @Override
    public Set<String> fetchResources(String userId, String token) throws Exception {
        String infoJson;
        MsGetUserExtraInfoRequest msGetUserExtraInfoRequest = new MsGetUserExtraInfoRequest();
        int appId = Integer.parseInt(this.appid);
        msGetUserExtraInfoRequest.setAppId(appId);
        msGetUserExtraInfoRequest.setResources(true);
        MsGetUserExtraInfoResponse msGetUserExtraInfoResponse = this.userExtraInfoClientService.userExtraInfo(token, msGetUserExtraInfoRequest);
        if (msGetUserExtraInfoResponse.getCode() != 1) {
            log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u5185\u90e8\u9519\u8bef:" + msGetUserExtraInfoResponse.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)(infoJson = msGetUserExtraInfoResponse.getInfoJson()))) {
            log.info("\u83b7\u53d6\u7528\u6237\u989d\u5916\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
            return Sets.newHashSet();
        }
        ExtraInfoModel extraInfoModel = (ExtraInfoModel)JsonUtils.fromJson((String)infoJson, ExtraInfoModel.class);
        Set<String> resourceCodes = extraInfoModel.getResourceCodes();
        if (CollectionUtils.isEmpty(resourceCodes)) {
            log.warn("infoJson:" + JSON.toJSONString((Object)msGetUserExtraInfoResponse));
        }
        log.info("\u83b7\u53d6\u5230\u7684\u6743\u9650\u4e3a: {}", resourceCodes);
        return resourceCodes;
    }
}

