package com.xforceplus.bi.commons.authority.usercenter.feign.decoder;

import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.domain.tenant.RoleDto;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.Org;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.core.utils.CompressionUtils;
import com.xforceplus.tenant.security.token.domain.TokenRole;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * Forked from com.xforceplus.tenant.security.server.interceptor.UserContextInterceptor
 *
 * @author xuejian
 */
@Slf4j
@Component
public class UserContextDecoder {
    @Value("${xforce.platforms.usercenter.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;

    @Value("${xforce.platforms.usercenter.appid:100}")
    private String appid;

    public <O extends Org<O>, R extends TokenRole, OO extends OrgDto<OO>, RR extends RoleDto> AuthorizedUser<OO, RoleDto> decode(String token, Long tenantId) {
        Map<String, String> claims = JwtUtils.verifyAndDecodeToken(this.secret, token);
        Assert.notNull(claims, "claims == null, 访问失败，没有登录");
        String encodedUserInfo = claims.get("userinfo");
        String userinfo = CompressionUtils.decode(encodedUserInfo);
        return setUserInfoHolder(userinfo, token, tenantId);
    }

    private <O extends Org<O>, R extends TokenRole, OO extends OrgDto<OO>, RR extends RoleDto> AuthorizedUser<OO, RR> setUserInfoHolder(
            String userinfo,
            String token,
            Long tenantId) {
        log.info("token = " + token);
        TokenUser<R> tokenUser = (TokenUser) JsonUtils.fromJson(userinfo, TokenUser.class);
        if (tokenUser == null) {
            log.warn("userinfo = " + userinfo);
            return null;
        } else {
            if (tenantId != null) {
                tokenUser.setTenantId(tenantId);
            }

            try {
                int appId = Integer.parseInt(this.appid);
                log.info("appId:" + appId);
            } catch (NumberFormatException var12) {
                log.warn("未设置appid");
                return null;
            }

            tokenUser.setToken(token);
            AuthorizedUser<OO, RR> authorizedUser = new AuthorizedUser();
            BeanUtils.copyProperties(tokenUser, authorizedUser);
            return authorizedUser;
        }
    }
}
