/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode.ResourceCodeClient;
import com.xforceplus.bi.commons.http.OkHttpInstance;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ResourceCodeV2Client
implements ResourceCodeClient {
    private static final Logger log = LoggerFactory.getLogger(ResourceCodeV2Client.class);
    @Value(value="${xforce.platforms.usercenter.url:}")
    private String userCenterUrl;
    @Autowired
    private OkHttpInstance okHttpInstance;

    @Override
    public String version() {
        return "v2";
    }

    @Override
    public Set<String> fetchResources(String userId, String token) throws Exception {
        String url = this.userCenterUrl + "/api/global/v2/users/" + userId + "?extraInfo=4";
        HashMap header = Maps.newHashMap();
        header.put(UserType.USER.tokenKey(), token);
        Response response = this.okHttpInstance.getToResponse(url, null, (Map)header);
        ResponseBody body = response.body();
        String result = new String(body.bytes());
        if (!response.isSuccessful()) {
            log.error("\u8bf7\u6c42\u7528\u6237\u4e2d\u5fc3\u8d44\u6e90\u7801V2\u63a5\u53e3\u5931\u8d25,\u8fd4\u56de\u72b6\u6001\u7801\u4e3a:{},\u8fd4\u56de\u6d88\u606f\u4e3a:{},\u8fd4\u56de\u4f53\u4e3a:{}", new Object[]{response.code(), response.message(), result});
            throw new RuntimeException(response.message());
        }
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        Object resultObject = jsonObject.get((Object)"result");
        Assert.notNull((Object)resultObject, (String)"\u8d44\u6e90\u7801\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        List resourceCodes = (List)((Map)resultObject).get("resourceCodes");
        return Sets.newHashSet((Iterable)resourceCodes);
    }
}

