/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.xplat;

import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.encryptions.xplat.beans.XplatParseToken;
import com.xforceplus.bi.commons.authority.util.DetermineAuthUtil;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.xplat.XplatTokenBody;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class XplatAuthEncryption
implements AuthEncryptionInterface {
    private static final Logger log = LoggerFactory.getLogger(XplatAuthEncryption.class);
    @Value(value="${xforce.platforms.xplat.accessTokenKey:X-Access-Token}")
    private String accessTokenKey = "";
    @Value(value="${xforce.platforms.xplat.operationToken:X-Operation-Token}")
    private String operationToken = "";
    @Autowired
    private XplatParseToken xplatParseToken;

    @Override
    public String tokenKey() {
        return this.accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest request) {
        if (!DetermineAuthUtil.isFromAthena(request)) {
            log.error("Cookie\u4e2d\u4e0d\u5305\u542b3.0\u7684Token");
            return null;
        }
        String accessToken = request.getHeader(this.accessTokenKey);
        if (accessToken == null) {
            accessToken = request.getParameter("access_token");
        }
        return accessToken;
    }

    @Override
    public UserInfo decode(HttpServletRequest httpServletRequest) throws Exception {
        String accessToken = this.token(httpServletRequest);
        UserInfo<XplatTokenBody> userInfo = this.xplatParseToken.validateToken(accessToken);
        if (userInfo == null) {
            return null;
        }
        boolean b = this.xplatParseToken.permissionAuth(httpServletRequest, userInfo);
        if (!b) {
            return null;
        }
        return userInfo;
    }
}

