/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.bi.commons.authority.service.TokenManagerService;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.web.utils.JsonUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TokenManagerServiceImpl
implements TokenManagerService {
    private static final Logger log = LoggerFactory.getLogger(TokenManagerServiceImpl.class);
    public static final String LOCK_KEY = "xforce_bi:access_token_lock:";
    public static final String TOKEN_KEY = "xforce_bi:access_token:";
    @Value(value="${xforce.auth.tokenTimeOut:3600}")
    private long tokenTimeOut;
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public UserInfo getUser(String token) {
        RBucket bucket = this.redissonClient.getBucket(this.genAccessTokenPath(token));
        if (!bucket.isExists()) {
            return null;
        }
        UserInfo userInfo = (UserInfo)JSONObject.parseObject((String)((String)bucket.get()), UserInfo.class);
        if (userInfo != null && StringUtils.isEmpty((CharSequence)userInfo.getAccessToken())) {
            userInfo.setAccessToken(token);
        }
        RequestUserContext.set((UserInfo)userInfo);
        if (userInfo != null && userInfo.getAuthSource() == AuthSource.USER_CENTER) {
            AuthorizedUser authorizedUser = (AuthorizedUser)JsonUtils.fromJson((String)JSON.toJSONString((Object)userInfo.getOrigin()), AuthorizedUser.class);
            if (authorizedUser != null) {
                log.info("\u5b58\u5165AuthorizedUser\u5230ThreadLocal");
                UserInfoHolder.put((IAuthorizedUser)authorizedUser);
            } else {
                log.info("AuthorizedUser is null");
            }
        }
        return userInfo;
    }

    @Override
    public void putUserOrRefreshExpire(String token, UserInfo authorizedUserInfo) {
        this.putUserOrRefreshExpire(token, authorizedUserInfo, this.tokenTimeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putUserOrRefreshExpire(String token, UserInfo authorizedUserInfo, long timeSecond) {
        RLock lock = this.redissonClient.getLock(LOCK_KEY + token);
        try {
            boolean locked = lock.tryLock(3L, TimeUnit.SECONDS);
            RBucket bucket = this.redissonClient.getBucket(this.genAccessTokenPath(token));
            if (!bucket.isExists() && locked) {
                String userStr = JSONObject.toJSONString((Object)authorizedUserInfo);
                log.info("\u5b58Redis\u7684\u7528\u6237\u4fe1\u606f:{}", (Object)userStr);
                bucket.set((Object)userStr, timeSecond, TimeUnit.SECONDS);
                AuthSource authSource = authorizedUserInfo.getAuthSource();
                log.info("\u8ba4\u8bc1\u6210\u529f => {}\u65b9\u5f0f", (Object)(authSource == null ? "\u672a\u77e5" : authSource.getDescription()));
            } else {
                bucket.expire(timeSecond, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58token\u5931\u8d25", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
    }

    private String genAccessTokenPath(String accessToken) {
        return TOKEN_KEY.concat(accessToken);
    }
}

