/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.internal;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.encryptions.internal.beans.InternalUserBean;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.tenant.security.core.jwt.JwtUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.web.util.WebUtils;

public class InternalAuthEncryption
implements AuthEncryptionInterface {
    private static final Logger log = LoggerFactory.getLogger(InternalAuthEncryption.class);
    @Value(value="${xforce.platforms.usercenter.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;

    @Override
    public String tokenKey() {
        return UserType.APPID.tokenKey();
    }

    @Override
    public String token(HttpServletRequest request) {
        Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.tokenKey());
        if (tokenCookie != null) {
            return tokenCookie.getValue();
        }
        String token = request.getHeader(this.tokenKey());
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            return token;
        }
        return WebUtils.findParameterValue((ServletRequest)request, (String)this.tokenKey());
    }

    @Override
    public UserInfo decode(HttpServletRequest request) throws Exception {
        String token = this.token(request);
        Map claims = JwtUtils.verifyAndDecodeToken((String)this.secret, (String)token);
        log.info(JSONObject.toJSONString((Object)claims));
        InternalUserBean userinfo = (InternalUserBean)JSONObject.parseObject((String)((String)claims.get("userinfo")), InternalUserBean.class);
        String clientAppId = String.valueOf(userinfo.getClientAppId());
        Assert.isTrue((System.currentTimeMillis() < Long.parseLong((String)claims.get("expireTime")) ? 1 : 0) != 0, (String)"\u8be5Token\u5df2\u8fc7\u671f");
        UserInfo userInfo = new UserInfo();
        userInfo.setId(clientAppId);
        userInfo.setName(userinfo.getClientId());
        userInfo.setAuthSource(AuthSource.XFORCEPLUS_INTERNAL);
        return userInfo;
    }
}

