/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.authority.encryptions.usercenter;

import com.google.common.collect.Sets;
import com.xforceplus.bi.commons.authority.encryptions.AuthEncryptionInterface;
import com.xforceplus.bi.commons.authority.usercenter.feign.decoder.UserContextDecoder;
import com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode.ResourceCodeClient;
import com.xforceplus.bi.commons.authority.usercenter.feign.resourcecode.ResourceCodeClientProvider;
import com.xforceplus.bi.commons.integration.platform.AuthSource;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.jdk.net.URLUtils;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.IRole;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.WebUtils;

public class UserCenterAuthEncryption
implements AuthEncryptionInterface {
    private static final Logger log = LoggerFactory.getLogger(UserCenterAuthEncryption.class);
    @Autowired
    private ResourceCodeClientProvider resourceCodeClientProvider;
    @Value(value="${xforce.platforms.usercenter.resourcecode.version:v2}")
    private String resourceCodeVersion;
    @Value(value="${xforce.platforms.usercenter.accessTokenKey:xforce-saas-token}")
    private String accessTokenKey = "";
    @Autowired
    private UserContextDecoder userContextDecoder;

    @Override
    public String tokenKey() {
        return this.accessTokenKey;
    }

    @Override
    public String token(HttpServletRequest request) {
        Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)UserType.USER.tokenKey());
        if (tokenCookie != null) {
            return tokenCookie.getValue();
        }
        String tokenHeader = request.getHeader(this.accessTokenKey);
        if (StringUtils.isNotEmpty((CharSequence)tokenHeader)) {
            return tokenHeader;
        }
        String tokenParam = WebUtils.findParameterValue((ServletRequest)request, (String)UserType.USER.tokenKey());
        if (StringUtils.isNotEmpty((CharSequence)tokenParam)) {
            return tokenParam;
        }
        try {
            Map referer = URLUtils.params((String)request.getHeader("referer"));
            String token = (String)referer.get("token");
            log.info("\u540e\u7aef\u4ecehead\u4e2d\u7684referer\u53d6\u5230token");
            return token;
        }
        catch (Exception e) {
            log.error("\u5206\u6790\u7528\u6237\u4e2d\u5fc3referer token\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    public UserInfo decode(HttpServletRequest request) throws Exception {
        String token = this.token(request);
        AuthorizedUser authorizedUser = this.userContextDecoder.decode(token, this.getTenantId(request));
        ResourceCodeClient resourceCodeClient = this.resourceCodeClientProvider.getInstance(this.resourceCodeVersion);
        Set resources = resourceCodeClient.fetchResources(String.valueOf(authorizedUser.getId()), token);
        log.debug("\u7528\u6237({})\u83b7\u53d6\u5230\u8d44\u6e90\u7801:{}", (Object)authorizedUser.getUsername(), (Object)resources);
        authorizedUser.setResourceCodes(resources);
        UserInfoHolder.put((IAuthorizedUser)authorizedUser);
        UserInfo<AuthorizedUser> retUser = this.transferToBIUser(authorizedUser);
        return retUser;
    }

    private UserInfo<AuthorizedUser> transferToBIUser(AuthorizedUser userOfUserCenter) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(String.valueOf(userOfUserCenter.getId()));
        userInfo.setAuthSource(AuthSource.USER_CENTER);
        userInfo.setUsername(userOfUserCenter.getUsername());
        userInfo.setTenantId(String.valueOf(userOfUserCenter.getTenantId()));
        userInfo.setTenantCode(userOfUserCenter.getTenantCode());
        userInfo.setMobile(userOfUserCenter.getMobile());
        userInfo.setEmail(userOfUserCenter.getEmail());
        userInfo.setName(userOfUserCenter.getUsername());
        HashSet roles = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)userOfUserCenter.getRoles())) {
            for (Object role : userOfUserCenter.getRoles()) {
                roles.add(String.valueOf(((IRole)role).getId()));
            }
        } else {
            log.warn("\u8be5\u7528\u6237({})\u7684\u89d2\u8272\u4e3a\u7a7a", (Object)userOfUserCenter.getUsername());
        }
        userInfo.setRoles((Set)roles);
        userInfo.setOrigin((Object)userOfUserCenter);
        userInfo.setResources(userOfUserCenter.getResourceCodes());
        return userInfo;
    }

    private Long getTenantId(HttpServletRequest request) {
        Long tenantId;
        Map pathVariables;
        String tenantIdStr = request.getHeader("tenantId");
        if (tenantIdStr == null && !CollectionUtils.isEmpty((Map)(pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE)))) {
            tenantIdStr = (String)pathVariables.get("tenantId");
        }
        try {
            tenantId = Long.parseLong(tenantIdStr);
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage() + ", tenantId = " + tenantIdStr);
            tenantId = null;
        }
        return tenantId;
    }
}

