/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.datasourceinstance.service.service.impl;

import com.google.common.collect.Maps;
import com.xforceplus.bi.commons.datasourceinstance.core.JdbcDbType;
import com.xforceplus.bi.commons.datasourceinstance.service.beans.AvailableDatasourceInstanceOption;
import com.xforceplus.bi.commons.datasourceinstance.service.beans.DatasourceAttributeBean;
import com.xforceplus.bi.commons.datasourceinstance.service.beans.DatasourceInstanceBean;
import com.xforceplus.bi.commons.datasourceinstance.service.beans.JdbcTypeOption;
import com.xforceplus.bi.commons.datasourceinstance.service.dao.DatasourceInstanceManagerDao;
import com.xforceplus.bi.commons.datasourceinstance.service.dto.DataSourceInstanceDto;
import com.xforceplus.bi.commons.datasourceinstance.service.dto.DatasourceInstanceAttributeDto;
import com.xforceplus.bi.commons.datasourceinstance.service.params.DataSourceSaveParam;
import com.xforceplus.bi.commons.datasourceinstance.service.service.DatasourceInstanceManagerService;
import com.xforceplus.bi.commons.datasourceinstance.service.vo.DataSourceDetailVo;
import com.xforceplus.bi.commons.datasourceinstance.service.vo.DataSourceListVo;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import com.xforceplus.bi.commons.jdk.util.UUIDUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DatasourceInstanceManagerServiceImpl
implements DatasourceInstanceManagerService {
    @Autowired
    private DatasourceInstanceManagerDao datasourceInstanceManagerDao;

    @Override
    public List<JdbcTypeOption> findJdbcTypeOptions() {
        return Arrays.stream(JdbcDbType.values()).map(item -> JdbcTypeOption.builder().id(item.name()).name(item.name()).build()).collect(Collectors.toList());
    }

    @Override
    public List<DataSourceListVo> findDatasourceInstancesByNameLike(String datasourceInstanceName) {
        String instanceNameLikeWords = StringUtils.isNotEmpty((CharSequence)datasourceInstanceName) ? "%" + datasourceInstanceName + "%" : null;
        return this.datasourceInstanceManagerDao.findDatasourceInstancesByNameLike(RequestUserContext.get().getTenantCode(), instanceNameLikeWords);
    }

    @Override
    public List<AvailableDatasourceInstanceOption> findAvailableDatasourceInstances() {
        return this.datasourceInstanceManagerDao.findAvailableDatasourceInstances(RequestUserContext.get().getTenantCode());
    }

    @Override
    public DataSourceDetailVo findDatasourceInstanceById(String datasourceInstanceId) {
        DatasourceInstanceBean datasourceInstanceBean = this.datasourceInstanceManagerDao.findDatasourceInstanceById(datasourceInstanceId);
        return this.getDataSourceDetailVo(datasourceInstanceId, datasourceInstanceBean);
    }

    @Override
    public DataSourceDetailVo findEncryptDatasourceInstanceById(String datasourceInstanceId) {
        DatasourceInstanceBean datasourceInstanceBean = this.datasourceInstanceManagerDao.findDatasourceInstanceById(datasourceInstanceId);
        return this.getEncryptDataSourceDetailVo(datasourceInstanceId, datasourceInstanceBean);
    }

    @Override
    public DataSourceDetailVo findDatasourceInstanceByName(String datasourceInstanceName) {
        DatasourceInstanceBean datasourceInstanceBean = this.datasourceInstanceManagerDao.findDatasourceInstanceByName(datasourceInstanceName);
        return this.getDataSourceDetailVo(datasourceInstanceBean.getId(), datasourceInstanceBean);
    }

    @Override
    public DataSourceDetailVo findEncryptDatasourceInstanceByName(String datasourceInstanceName) {
        DatasourceInstanceBean datasourceInstanceBean = this.datasourceInstanceManagerDao.findDatasourceInstanceByName(datasourceInstanceName);
        return this.getEncryptDataSourceDetailVo(datasourceInstanceBean.getId(), datasourceInstanceBean);
    }

    private DataSourceDetailVo getDataSourceDetailVo(String datasourceInstanceId, DatasourceInstanceBean datasourceInstanceBean) {
        if (datasourceInstanceBean == null) {
            return null;
        }
        DataSourceDetailVo dataSourceDetailVo = new DataSourceDetailVo();
        List<DatasourceAttributeBean> datasourceAttributeBeans = this.datasourceInstanceManagerDao.findDatasourceInstanceAttributes(datasourceInstanceId);
        dataSourceDetailVo.setId(datasourceInstanceBean.getId());
        dataSourceDetailVo.setName(datasourceInstanceBean.getName());
        dataSourceDetailVo.setType(datasourceInstanceBean.getType());
        dataSourceDetailVo.setJdbcType(datasourceInstanceBean.getJdbcType());
        dataSourceDetailVo.setAvailable(datasourceInstanceBean.isAvailable());
        dataSourceDetailVo.setTenant(datasourceInstanceBean.getTenant());
        dataSourceDetailVo.setAttributes((Map<String, String>)(CollectionUtils.isEmpty(datasourceAttributeBeans) ? Maps.newHashMap() : datasourceAttributeBeans.stream().collect(Collectors.toMap(DatasourceAttributeBean::getAttributeKey, DatasourceAttributeBean::getAttributeVal))));
        return dataSourceDetailVo;
    }

    private DataSourceDetailVo getEncryptDataSourceDetailVo(String datasourceInstanceId, DatasourceInstanceBean datasourceInstanceBean) {
        if (datasourceInstanceBean == null) {
            return null;
        }
        DataSourceDetailVo dataSourceDetailVo = new DataSourceDetailVo();
        List<DatasourceAttributeBean> datasourceAttributeBeans = this.datasourceInstanceManagerDao.findEncryptDatasourceInstanceAttributes(datasourceInstanceId);
        dataSourceDetailVo.setId(datasourceInstanceBean.getId());
        dataSourceDetailVo.setName(datasourceInstanceBean.getName());
        dataSourceDetailVo.setType(datasourceInstanceBean.getType());
        dataSourceDetailVo.setJdbcType(datasourceInstanceBean.getJdbcType());
        dataSourceDetailVo.setAvailable(datasourceInstanceBean.isAvailable());
        dataSourceDetailVo.setTenant(datasourceInstanceBean.getTenant());
        dataSourceDetailVo.setAttributes((Map<String, String>)(CollectionUtils.isEmpty(datasourceAttributeBeans) ? Maps.newHashMap() : datasourceAttributeBeans.stream().collect(Collectors.toMap(DatasourceAttributeBean::getAttributeKey, DatasourceAttributeBean::getAttributeVal))));
        return dataSourceDetailVo;
    }

    @Override
    @Transactional
    public void deleteDatasourceInstance(String datasourceInstanceId) {
        this.datasourceInstanceManagerDao.deleteDatasourceInstance(datasourceInstanceId);
        this.datasourceInstanceManagerDao.deleteDatasourceInstanceAttributes(datasourceInstanceId);
    }

    @Override
    @Transactional
    public String addDatasourceInstance(DataSourceSaveParam dataSourceSaveParam) {
        UserInfo userInfo = RequestUserContext.get();
        this.checkDatasourceNameUnique(null, dataSourceSaveParam.getName());
        DataSourceInstanceDto dataSourceInstanceDto = DataSourceInstanceDto.builder().id(UUIDUtil.gen()).name(dataSourceSaveParam.getName()).type(dataSourceSaveParam.getType()).available(dataSourceSaveParam.isAvailable()).jdbcType(dataSourceSaveParam.getJdbcType()).creator(this.creator()).belongPlatform(userInfo.getAuthSource().name()).belongTenant(userInfo.getTenantCode()).build();
        this.datasourceInstanceManagerDao.insertDatasourceInstance(dataSourceInstanceDto);
        this.insertDatasourceInstanceAttributes(dataSourceSaveParam.getAttributes(), dataSourceInstanceDto.getId());
        return dataSourceInstanceDto.getId();
    }

    private String creator() {
        UserInfo userInfo = RequestUserContext.get();
        if (StringUtils.isNotEmpty((CharSequence)userInfo.getUsername())) {
            return userInfo.getUsername();
        }
        return userInfo.getName();
    }

    private void insertDatasourceInstanceAttributes(Map<String, String> datasourceInstanceAttributes, String dataSourceInstanceId) {
        this.insertDatasourceInstanceAttributes(datasourceInstanceAttributes, dataSourceInstanceId, true);
    }

    private void insertUnencryptDatasourceInstanceAttributes(Map<String, String> datasourceInstanceAttributes, String dataSourceInstanceId) {
        this.insertDatasourceInstanceAttributes(datasourceInstanceAttributes, dataSourceInstanceId, false);
    }

    private void insertDatasourceInstanceAttributes(Map<String, String> datasourceInstanceAttributes, String dataSourceInstanceId, boolean encrypt) {
        if (MapUtils.isEmpty(datasourceInstanceAttributes)) {
            return;
        }
        ArrayList<DatasourceInstanceAttributeDto> datasourceInstanceAttributeDtos = new ArrayList<DatasourceInstanceAttributeDto>();
        datasourceInstanceAttributes.forEach((key, val) -> datasourceInstanceAttributeDtos.add(DatasourceInstanceAttributeDto.builder().id(UUIDUtil.gen()).datasourceInstanceId(dataSourceInstanceId).attributeKey((String)key).attributeVal((String)val).build()));
        if (encrypt) {
            this.datasourceInstanceManagerDao.insertDatasourceInstanceAttributes(datasourceInstanceAttributeDtos);
        } else {
            this.datasourceInstanceManagerDao.insertUnencryptDatasourceInstanceAttributes(datasourceInstanceAttributeDtos);
        }
    }

    private void checkDatasourceNameUnique(String id, String name) {
        Integer datasourceInstanceNameExists = this.datasourceInstanceManagerDao.datasourceInstanceNameExists(id, name);
        Assert.isNull((Object)datasourceInstanceNameExists, (String)("\u6b64\u540d\u79f0(" + name + ")\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165"));
    }

    @Override
    public void updateDatasourceInstance(String datasourceInstanceId, DataSourceSaveParam dataSourceSaveParam) {
        UserInfo userInfo = RequestUserContext.get();
        this.checkDatasourceNameUnique(datasourceInstanceId, dataSourceSaveParam.getName());
        DataSourceInstanceDto dataSourceInstanceDto = DataSourceInstanceDto.builder().id(datasourceInstanceId).name(dataSourceSaveParam.getName()).type(dataSourceSaveParam.getType()).available(dataSourceSaveParam.isAvailable()).jdbcType(dataSourceSaveParam.getJdbcType()).creator(this.creator()).belongPlatform(userInfo.getAuthSource().name()).belongTenant(userInfo.getTenantCode()).build();
        this.datasourceInstanceManagerDao.updateDatasourceInstance(dataSourceInstanceDto);
        this.datasourceInstanceManagerDao.deleteDatasourceInstanceAttributes(datasourceInstanceId);
        this.insertDatasourceInstanceAttributes(dataSourceSaveParam.getAttributes(), dataSourceInstanceDto.getId());
    }

    @Override
    public void updateDatasourceInstanceWithNoEncrypt(String datasourceInstanceId, DataSourceSaveParam dataSourceSaveParam) {
        UserInfo userInfo = RequestUserContext.get();
        this.checkDatasourceNameUnique(datasourceInstanceId, dataSourceSaveParam.getName());
        DataSourceInstanceDto dataSourceInstanceDto = DataSourceInstanceDto.builder().id(datasourceInstanceId).name(dataSourceSaveParam.getName()).type(dataSourceSaveParam.getType()).available(dataSourceSaveParam.isAvailable()).jdbcType(dataSourceSaveParam.getJdbcType()).creator(this.creator()).belongPlatform(userInfo.getAuthSource().name()).belongTenant(userInfo.getTenantCode()).build();
        this.datasourceInstanceManagerDao.updateDatasourceInstance(dataSourceInstanceDto);
        this.datasourceInstanceManagerDao.deleteDatasourceInstanceAttributes(datasourceInstanceId);
        this.insertUnencryptDatasourceInstanceAttributes(dataSourceSaveParam.getAttributes(), dataSourceInstanceDto.getId());
    }
}

