/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.datasourceinstance.service.dao;

import com.xforceplus.bi.commons.datasourceinstance.service.beans.AvailableDatasourceInstanceOption;
import com.xforceplus.bi.commons.datasourceinstance.service.beans.DatasourceAttributeBean;
import com.xforceplus.bi.commons.datasourceinstance.service.beans.DatasourceInstanceBean;
import com.xforceplus.bi.commons.datasourceinstance.service.dto.DataSourceInstanceDto;
import com.xforceplus.bi.commons.datasourceinstance.service.dto.DatasourceInstanceAttributeDto;
import com.xforceplus.bi.commons.datasourceinstance.service.vo.DataSourceListVo;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface DatasourceInstanceManagerDao {
    public static final String PASSWORD_ENCODE_KEY = "PASSWORD_ENCODE_KEY";

    @Select(value={"<script>", "SELECT w02di.id_datasource_instance AS id,", "       w02di.name AS name,", "       w02di.type AS type,", "       w02di.jdbc_type AS jdbcType,", "       w02di.available AS available,", "       w02di.last_updated_time AS lastUpdatedTime", "  FROM bi_worker_02_datasource_instance w02di ", " where w02di.belong_tenant = #{tenantCode}", "<if test=\"instanceNameLikeWords != null and instanceNameLikeWords != ''\">", "   and w02di.name like #{instanceNameLikeWords}", "</if>", "</script>"})
    public List<DataSourceListVo> findDatasourceInstancesByNameLike(@Param(value="tenantCode") String var1, @Param(value="instanceNameLikeWords") String var2);

    @Select(value={"SELECT w02di.id_datasource_instance AS code,\n               w02di.name                   AS name\n        FROM bi_worker_02_datasource_instance w02di\n        where (w02di.belong_tenant = #{tenantCode}\n            or w02di.id_datasource_instance = 'default')\n          and w02di.available = '1'"})
    public List<AvailableDatasourceInstanceOption> findAvailableDatasourceInstances(@Param(value="tenantCode") String var1);

    @Select(value={"SELECT w02di.id_datasource_instance AS id,\n       w02di.name                   AS name,\n       w02di.type                   AS type,\n       w02di.belong_tenant          AS tenant,\n       w02di.jdbc_type              AS jdbcType,\n       w02di.available              AS available\nFROM bi_worker_02_datasource_instance w02di\nwhere w02di.id_datasource_instance = #{datasourceInstanceId}"})
    public DatasourceInstanceBean findDatasourceInstanceById(@Param(value="datasourceInstanceId") String var1);

    @Select(value={"SELECT w02di.id_datasource_instance AS id,\n       w02di.name                   AS name,\n       w02di.type                   AS type,\n       w02di.belong_tenant          AS tenant,\n       w02di.jdbc_type              AS jdbcType,\n       w02di.available              AS available\nFROM bi_worker_02_datasource_instance w02di\nwhere w02di.name = #{name}"})
    public DatasourceInstanceBean findDatasourceInstanceByName(String var1);

    @Select(value={"select w03da.attribute_key as attributeKey,\n       w03da.attribute_val as attributeVal\nfrom bi_worker_03_datasource_attribute w03da\nwhere w03da.belong_datasource_instance = #{datasourceInstanceId}"})
    public List<DatasourceAttributeBean> findEncryptDatasourceInstanceAttributes(@Param(value="datasourceInstanceId") String var1);

    @Select(value={"select w03da.attribute_key as attributeKey,\n        IF(w03da.attribute_key = 'password', AES_DECRYPT(UNHEX(w03da.attribute_val), 'PASSWORD_ENCODE_KEY'), attribute_val) as attributeVal\nfrom bi_worker_03_datasource_attribute w03da\nwhere w03da.belong_datasource_instance = #{datasourceInstanceId}"})
    public List<DatasourceAttributeBean> findDatasourceInstanceAttributes(@Param(value="datasourceInstanceId") String var1);

    @Delete(value={"delete from bi_worker_02_datasource_instance where id_datasource_instance = #{datasourceInstanceId}"})
    public void deleteDatasourceInstance(@Param(value="datasourceInstanceId") String var1);

    @Delete(value={"delete from bi_worker_03_datasource_attribute where belong_datasource_instance = #{datasourceInstanceId}"})
    public void deleteDatasourceInstanceAttributes(@Param(value="datasourceInstanceId") String var1);

    @Insert(value={"INSERT INTO bi_worker_02_datasource_instance\n        (id_datasource_instance,\n         name,\n         type,\n         jdbc_type,\n         available,\n         creator,\n         belong_platform,\n         belong_tenant)\n        VALUES (#{id},\n                #{name},\n                #{type},\n                #{jdbcType},\n                #{available},\n                #{creator},\n                #{belongPlatform},\n                #{belongTenant})"})
    public void insertDatasourceInstance(DataSourceInstanceDto var1);

    @Insert(value={"<script>", "INSERT INTO bi_worker_03_datasource_attribute", "(", "id_datasource_attribute,", "belong_datasource_instance,", "attribute_key,", "attribute_val", ")", "VALUES", "<foreach collection=\"attributes\" index=\"index\" item=\"item\" separator=\",\">", "    (", "    #{item.id},", "    #{item.datasourceInstanceId},", "    #{item.attributeKey},", "    IF(attribute_key = 'password', HEX(AES_ENCRYPT(#{item.attributeVal}, 'PASSWORD_ENCODE_KEY')), #{item.attributeVal}) ", "    )", "</foreach>", "</script>"})
    public void insertDatasourceInstanceAttributes(@Param(value="attributes") List<DatasourceInstanceAttributeDto> var1);

    @Insert(value={"<script>", "INSERT INTO bi_worker_03_datasource_attribute", "(", "id_datasource_attribute,", "belong_datasource_instance,", "attribute_key,", "attribute_val", ")", "VALUES", "<foreach collection=\"attributes\" index=\"index\" item=\"item\" separator=\",\">", "    (", "    #{item.id},", "    #{item.datasourceInstanceId},", "    #{item.attributeKey},", "    #{item.attributeVal}", "    )", "</foreach>", "</script>"})
    public void insertUnencryptDatasourceInstanceAttributes(@Param(value="attributes") List<DatasourceInstanceAttributeDto> var1);

    @Select(value={"<script>", "select 1 from bi_worker_02_datasource_instance", " where name = #{name}", "<if test=\"id != null and id != ''\">", "   and id_datasource_instance != #{id}", "</if>", "</script>"})
    public Integer datasourceInstanceNameExists(@Param(value="id") String var1, @Param(value="name") String var2);

    @Update(value={"UPDATE bi_worker_02_datasource_instance\n        SET name=#{name},\n            type=#{type},\n            jdbc_type = #{jdbcType},\n            available=#{available},\n            creator=#{creator},\n            belong_platform=#{belongPlatform},\n            belong_tenant=#{belongTenant}\n        WHERE id_datasource_instance = #{id}"})
    public void updateDatasourceInstance(DataSourceInstanceDto var1);
}

