package com.xforceplus.bi.commons.disruptor.config;

import com.xforceplus.bi.commons.disruptor.DisruptorWorker;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
public class DisruptorConfig {
    @Value("${disruptor.workernum:8}")
    private int workernum;

    /**
     * 注册disruptor
     *
     * @return
     */
    @Bean(destroyMethod = "close")
    public DisruptorWorker disruptorWorker() {
        log.info("disruptor线程数：{}", workernum);
        return DisruptorWorker.create(workernum);
    }
}
