/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.disruptor;

import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.xforceplus.bi.commons.disruptor.DisruptorHandler;
import com.xforceplus.bi.commons.disruptor.bean.TaskEvent;
import com.xforceplus.bi.commons.disruptor.bean.TaskEventFactory;
import com.xforceplus.bi.commons.disruptor.service.WorkService;
import com.xforceplus.bi.commons.jdk.concurrent.ExecutorHelper;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorWorker {
    private static final Logger log = LoggerFactory.getLogger(DisruptorWorker.class);
    private int workers = 1;
    private WaitStrategy strategy;
    private Disruptor<TaskEvent> disruptor;
    private RingBuffer<TaskEvent> ringBuffer;

    public DisruptorWorker(int workers) {
        this.workers = workers;
    }

    public DisruptorWorker() {
    }

    public static DisruptorWorker create(int leftMoveWorkers) {
        DisruptorWorker disruptorWorker = new DisruptorWorker(leftMoveWorkers);
        disruptorWorker.start();
        return disruptorWorker;
    }

    private void init() {
        this.workers = this.workers < 4 ? 4 : this.workers;
        WorkHandler[] workHandlers = new WorkHandler[this.workers];
        TaskEventFactory eventFactory = new TaskEventFactory();
        for (int i = 0; i < this.workers; ++i) {
            workHandlers[i] = new DisruptorHandler();
        }
        if (this.strategy == null) {
            this.strategy = new BusySpinWaitStrategy();
        }
        this.disruptor = new Disruptor((EventFactory)eventFactory, 1024, ExecutorHelper.buildNameThreadFactory((String)"datasource-worker", (boolean)true), ProducerType.SINGLE, this.strategy);
        this.disruptor.handleEventsWithWorkerPool(workHandlers);
    }

    public void start() {
        this.init();
        this.ringBuffer = this.disruptor.start();
    }

    @PreDestroy
    public void close() {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
        log.info("Close");
    }

    public <T> void addTask(final T t, final WorkService<T> workService) {
        this.ringBuffer.publishEvent((EventTranslator)new EventTranslator<TaskEvent>(){

            public void translateTo(TaskEvent event, long sequence) {
                event.setTask(t);
                event.setWorkService(workService);
            }
        });
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }
}

