/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.email;

import com.xforceplus.bi.commons.email.EmailService;
import com.xforceplus.bi.commons.email.request.Attachment;
import com.xforceplus.bi.commons.email.request.MailRequest;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    private static final String FROM_TEMPLATE = "%s<%s>";
    @Autowired
    private JavaMailSender mailSender;
    @Value(value="${spring.mail.username}")
    private String from;
    @Value(value="${spring.mail.nickname:\u6570\u636e\u5e73\u53f0}")
    private String nickname;

    @Override
    public void send(MailRequest request) throws MessagingException {
        boolean hasAttachment = CollectionUtils.isNotEmpty(request.getAttachments());
        MimeMessage mimeMessage = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, hasAttachment);
        helper.setSubject(request.getSubject());
        helper.setText(request.getContent() == null ? "" : request.getContent(), true);
        helper.setFrom(String.format(FROM_TEMPLATE, this.nickname, this.from));
        helper.setTo(request.getTo().toArray(new String[request.getTo().size()]));
        if (CollectionUtils.isNotEmpty(request.getCc())) {
            helper.setCc(request.getCc().toArray(new String[request.getCc().size()]));
        }
        if (hasAttachment) {
            for (Attachment attachment : request.getAttachments()) {
                helper.addAttachment(attachment.getName(), attachment.getFile());
            }
        }
        this.mailSender.send(mimeMessage);
    }
}

