/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.email.request;

import com.xforceplus.bi.commons.email.request.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MailRequest {
    private String subject;
    private String content;
    private List<String> to;
    private List<String> cc;
    private List<Attachment> attachments;

    MailRequest(String subject, String content, List<String> to, List<String> cc, List<Attachment> attachments) {
        this.subject = subject;
        this.content = content;
        this.to = to;
        this.cc = cc;
        this.attachments = attachments;
    }

    public static MailRequestBuilder builder() {
        return new MailRequestBuilder();
    }

    public MailRequestBuilder toBuilder() {
        return new MailRequestBuilder().subject(this.subject).content(this.content).to(this.to).cc(this.cc).attachments(this.attachments);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getTo() {
        return this.to;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MailRequest)) {
            return false;
        }
        MailRequest other = (MailRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$to = this.getTo();
        List<String> other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        List<String> this$cc = this.getCc();
        List<String> other$cc = other.getCc();
        if (this$cc == null ? other$cc != null : !((Object)this$cc).equals(other$cc)) {
            return false;
        }
        List<Attachment> this$attachments = this.getAttachments();
        List<Attachment> other$attachments = other.getAttachments();
        return !(this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MailRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        List<String> $cc = this.getCc();
        result = result * 59 + ($cc == null ? 43 : ((Object)$cc).hashCode());
        List<Attachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        return result;
    }

    public String toString() {
        return "MailRequest(subject=" + this.getSubject() + ", content=" + this.getContent() + ", to=" + this.getTo() + ", cc=" + this.getCc() + ", attachments=" + this.getAttachments() + ")";
    }

    public static class MailRequestBuilder {
        private String subject;
        private String content;
        private List<String> to;
        private List<String> cc;
        private ArrayList<Attachment> attachments;

        MailRequestBuilder() {
        }

        public MailRequestBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public MailRequestBuilder content(String content) {
            this.content = content;
            return this;
        }

        public MailRequestBuilder to(List<String> to) {
            this.to = to;
            return this;
        }

        public MailRequestBuilder cc(List<String> cc) {
            this.cc = cc;
            return this;
        }

        public MailRequestBuilder attachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public MailRequestBuilder attachments(Collection<? extends Attachment> attachments) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public MailRequestBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public MailRequest build() {
            List<Attachment> attachments;
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<Attachment>(this.attachments));
                }
            }
            return new MailRequest(this.subject, this.content, this.to, this.cc, attachments);
        }

        public String toString() {
            return "MailRequest.MailRequestBuilder(subject=" + this.subject + ", content=" + this.content + ", to=" + this.to + ", cc=" + this.cc + ", attachments=" + this.attachments + ")";
        }
    }
}

