/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.http;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpInstance {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient okHttpClient;

    public OkHttpInstance(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public Response postFormToResponse(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Request.Builder request = new Request.Builder();
        request.url(url);
        if (head != null) {
            for (Map.Entry<String, String> entry : head.entrySet()) {
                String string = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        FormBody.Builder formBody = new FormBody.Builder();
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                formBody.add(entry.getKey(), entry.getValue());
            }
        }
        request.post((RequestBody)formBody.build());
        Response response = this.okHttpClient.newCall(request.build()).execute();
        return response;
    }

    public String postFormToString(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Response response = this.postFormToResponse(url, data, head);
        return response == null ? "" : response.body().string();
    }

    public <T> T postFormToClass(String url, Map<String, String> data, Map<String, String> head, Class<T> tClass) throws IOException {
        Response response = this.postFormToResponse(url, data, head);
        return (T)(response == null ? null : JSONObject.parseObject((String)response.body().string(), tClass));
    }

    public Response postBodyToResponse(String url, Object data, Map<String, String> head) throws IOException {
        Request.Builder request = new Request.Builder();
        request.url(url);
        if (head != null) {
            for (Map.Entry<String, String> stringStringEntry : head.entrySet()) {
                String key = stringStringEntry.getKey();
                String value = stringStringEntry.getValue();
                if (value == null) continue;
                request.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        if (data != null) {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)JSONObject.toJSONString((Object)data));
            request.post(body);
        }
        Response response = this.okHttpClient.newCall(request.build()).execute();
        return response;
    }

    public String postBodyToString(String url, Object data, Map<String, String> head) throws IOException {
        Response response = this.postBodyToResponse(url, data, head);
        return response == null ? "" : response.body().string();
    }

    public <T> T postBodyToClass(String url, Object data, Map<String, String> head, Class<T> tClass) throws IOException {
        Response response = this.postBodyToResponse(url, data, head);
        return (T)(response == null ? null : JSONObject.parseObject((String)response.body().string(), tClass));
    }

    public Response getToResponse(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Request.Builder request = new Request.Builder();
        if (head != null) {
            for (Map.Entry<String, String> stringStringEntry : head.entrySet()) {
                String key = stringStringEntry.getKey();
                String value = stringStringEntry.getValue();
                if (value == null) continue;
                request.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        if (data != null) {
            Iterator<String> i = data.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next();
                if (data.get(key) != null) continue;
                i.remove();
            }
            url = this.encodeUrl(data, url);
        }
        request.url(url).get();
        request.get();
        Response response = this.okHttpClient.newCall(request.build()).execute();
        return response;
    }

    public String getToString(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Response response = this.getToResponse(url, data, head);
        return response == null ? "" : response.body().string();
    }

    public <T> T getToClass(String url, Map<String, String> data, Map<String, String> head, Class<T> tClass) throws IOException {
        Response response = this.getToResponse(url, data, head);
        return (T)(response == null ? null : JSONObject.parseObject((String)response.body().string(), tClass));
    }

    private String encodeUrl(Map<String, String> data, String url) {
        StringBuffer stringBuffer = new StringBuffer(url);
        if (stringBuffer.indexOf("?") == -1) {
            stringBuffer.append("?");
        } else {
            stringBuffer.append("&");
        }
        for (Map.Entry<String, String> stringStringEntry : data.entrySet()) {
            stringBuffer.append(stringStringEntry.getKey());
            stringBuffer.append("=");
            stringBuffer.append(stringStringEntry.getValue());
            stringBuffer.append("&");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}

