package com.xforceplus.bi.commons.http;

import com.alibaba.fastjson.JSONObject;
import okhttp3.*;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class OkHttpInstance {

    public static final MediaType JSON
            = MediaType.parse("application/json; charset=utf-8");

    private OkHttpClient okHttpClient;

    public OkHttpInstance(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public Response postFormToResponse(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Request.Builder request = new Request.Builder();
        request.url(url);
        if (head != null) {
            for (Map.Entry<String, String> stringStringEntry : head.entrySet()) {
                String key = stringStringEntry.getKey();
                String value = stringStringEntry.getValue();
                if (value == null) {
                    continue;
                }
                request.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        //post方式提交的数据
        FormBody.Builder formBody = new FormBody.Builder();
        if (data != null) {
            for (Map.Entry<String, String> stringStringEntry : data.entrySet()) {
                formBody.add(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        request.post(formBody.build());
        Response response = okHttpClient.newCall(request.build()).execute();
        return response;
    }

    public String postFormToString(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Response response = postFormToResponse(url, data, head);
        return response == null ? "" : response.body().string();
    }

    public <T> T postFormToClass(String url, Map<String, String> data, Map<String, String> head, Class<T> tClass) throws IOException {
        Response response = postFormToResponse(url, data, head);
        return response == null ? null : JSONObject.parseObject(response.body().string(), tClass);
    }

    public Response postBodyToResponse(String url, Object data, Map<String, String> head) throws IOException {
        Request.Builder request = new Request.Builder();
        request.url(url);
        if (head != null) {
            for (Map.Entry<String, String> stringStringEntry : head.entrySet()) {
                String key = stringStringEntry.getKey();
                String value = stringStringEntry.getValue();
                if (value == null) {
                    continue;
                }
                request.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        if (data != null) {
            RequestBody body = RequestBody.create(JSON, JSONObject.toJSONString(data));
            request.post(body);
        }
        Response response = okHttpClient.newCall(request.build()).execute();
        return response;
    }

    public String postBodyToString(String url, Object data, Map<String, String> head) throws IOException {
        Response response = postBodyToResponse(url, data, head);
        return response == null ? "" : response.body().string();
    }

    public <T> T postBodyToClass(String url, Object data, Map<String, String> head, Class<T> tClass) throws IOException {
        Response response = postBodyToResponse(url, data, head);
        return response == null ? null : JSONObject.parseObject(response.body().string(), tClass);
    }

    public Response getToResponse(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Request.Builder request = new Request.Builder();
        if (head != null) {
            for (Map.Entry<String, String> stringStringEntry : head.entrySet()) {
                String key = stringStringEntry.getKey();
                String value = stringStringEntry.getValue();
                if (value == null) {
                    continue;
                }
                request.addHeader(stringStringEntry.getKey(), stringStringEntry.getValue());
            }
        }
        if (data != null) {
            Iterator<String> i = data.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next();
                // 去掉值为空null的参数
                if (data.get(key) == null) {
                    i.remove();
                }
            }
            url = encodeUrl(data, url);
        }
        request.url(url).get();
        request.get();
        Response response = okHttpClient.newCall(request.build()).execute();
        return response;
    }

    public String getToString(String url, Map<String, String> data, Map<String, String> head) throws IOException {
        Response response = getToResponse(url, data, head);
        return response == null ? "" : response.body().string();
    }

    public <T> T getToClass(String url, Map<String, String> data, Map<String, String> head, Class<T> tClass) throws IOException {
        Response response = getToResponse(url, data, head);
        return response == null ? null : JSONObject.parseObject(response.body().string(), tClass);
    }

    private String encodeUrl(Map<String, String> data, String url) {
        StringBuffer stringBuffer = new StringBuffer(url);
        if (stringBuffer.indexOf("?") == -1) {
            stringBuffer.append("?");
        } else {
            stringBuffer.append("&");
        }
        for (Map.Entry<String, String> stringStringEntry : data.entrySet()) {
            stringBuffer.append(stringStringEntry.getKey());
            stringBuffer.append("=");
            stringBuffer.append(stringStringEntry.getValue());
            stringBuffer.append("&");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }
}
