package com.xforceplus.bi.commons.integration.user.utils;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * TokenKey管理
 */
public class BiTokenKey {

    public static final String BI_TOKEN_KEY = "BI_TOKEN_KEY";

    /**
     * 设置tokenKey
     *
     * @param request
     * @param tokenKey
     */
    public static void set(HttpServletRequest request, String tokenKey) {
        request.setAttribute(BI_TOKEN_KEY, tokenKey);
    }

    /**
     * 取tokenkey
     *
     * @param request
     * @return
     */
    public static String get(HttpServletRequest request) {
        String tokenKey = request.getHeader(BI_TOKEN_KEY);
        if (StringUtils.isNotEmpty(tokenKey)) {
            return tokenKey;
        }
        return (String) request.getAttribute(BI_TOKEN_KEY);
    }

}
