package com.xforceplus.bi.commons.integration.user.beans;


import com.xforceplus.bi.commons.integration.platform.AuthSource;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * BI用户信息
 *
 * @param <O> 其它平台原始用户
 */
public class UserInfo<O> implements Serializable {

    private static final long serialVersionUID = -3311807602526664220L;
    private String id;
    private String username;
    private String password;
    private String mobile;
    private String name;
    private String tenantId;
    private String tenantCode;
    private String companyId;
    private String departId;
    private String fuc;
    private String email;
    private String gender;
    private boolean enabled;
    private boolean deleted;
    private String accessToken;
    private String projectId;
    private AuthSource authSource;
    private List<String> menusStr;
    private Map<String, String> commonUserHeader;
    // 权限Map: 表名-权限List
    private Map<String, List<UserModelPermission.DataPermission>> permissionParamS;
    private String wxId;
    private String wxSesseionKey;
    private boolean isRemeberMeToday = false;
    // 用户拥有的角色
    private Set<String> roles;
    // 4.0资源码
    private Set<String> resources;
    /**
     * 其它平台的用户对象转BI用户之前的原始值
     */
    private O origin;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantCode() {
        return tenantCode;
    }

    public List<String> getMenusStr() {
        return menusStr;
    }

    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getDepartId() {
        return departId;
    }

    public void setDepartId(String departId) {
        this.departId = departId;
    }

    public String getFuc() {
        return fuc;
    }

    public void setFuc(String fuc) {
        this.fuc = fuc;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public AuthSource getAuthSource() {
        return authSource;
    }

    public void setAuthSource(AuthSource authSource) {
        this.authSource = authSource;
    }

    public List<String> getMenus() {
        return menusStr;
    }

    public void setMenusStr(List<String> menusStr) {
        this.menusStr = menusStr;
    }

    public Map<String, String> getCommonUserHeader() {
        return commonUserHeader;
    }

    public void setCommonUserHeader(Map<String, String> commonUserHeader) {
        this.commonUserHeader = commonUserHeader;
    }

    public Map<String, List<UserModelPermission.DataPermission>> getPermissionParamS() {
        return permissionParamS;
    }

    public void setPermissionParamS(Map<String, List<UserModelPermission.DataPermission>> permissionParamS) {
        this.permissionParamS = permissionParamS;
    }

    public String getWxId() {
        return wxId;
    }

    public void setWxId(String wxId) {
        this.wxId = wxId;
    }

    public String getWxSesseionKey() {
        return wxSesseionKey;
    }

    public void setWxSesseionKey(String wxSesseionKey) {
        this.wxSesseionKey = wxSesseionKey;
    }

    public boolean isRemeberMeToday() {
        return isRemeberMeToday;
    }

    public void setRemeberMeToday(boolean remeberMeToday) {
        isRemeberMeToday = remeberMeToday;
    }

    public Set<String> getRoles() {
        return roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public O getOrigin() {
        return origin;
    }

    public void setOrigin(O origin) {
        this.origin = origin;
    }

    public Set<String> getResources() {
        return resources;
    }

    public void setResources(Set<String> resources) {
        this.resources = resources;
    }
}
