package com.xforceplus.bi.commons.integration.user.beans;

import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;

public class UserModelPermission {
    private String tableWithDatabase;
    private List<DataPermission> dataPermissions;

    public String getTableWithDatabase() {
        return tableWithDatabase;
    }

    public void setTableWithDatabase(String tableWithDatabase) {
        this.tableWithDatabase = tableWithDatabase;
    }

    public List<DataPermission> getDataPermissions() {
        return dataPermissions;
    }

    public void setDataPermissions(List<DataPermission> dataPermissions) {
        this.dataPermissions = dataPermissions;
    }

    public static class DataPermission implements Serializable {
        private Long fieldId;
        private String fieldType; // 原attrtype
        private String fieldFormat;
        private String fieldRealName;
        private String tableRealName;
        private List<DataPermissionValue> dataPermissionValues;

        public Long getFieldId() {
            return fieldId;
        }

        public void setFieldId(Long fieldId) {
            this.fieldId = fieldId;
        }

        public String getFieldType() {
            return fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public String getFieldFormat() {
            return fieldFormat;
        }

        public void setFieldFormat(String fieldFormat) {
            this.fieldFormat = fieldFormat;
        }

        public String getFieldRealName() {
            return fieldRealName;
        }

        public void setFieldRealName(String fieldRealName) {
            this.fieldRealName = fieldRealName;
        }

        public String getTableRealName() {
            return tableRealName;
        }

        public void setTableRealName(String tableRealName) {
            this.tableRealName = tableRealName;
        }

        public List<DataPermissionValue> getDataPermissionValues() {
            return dataPermissionValues;
        }

        public void setDataPermissionValues(List<DataPermissionValue> dataPermissionValues) {
            this.dataPermissionValues = dataPermissionValues;
        }

        public static class DataPermissionValue implements Serializable {
            private String selectType; // 原type
            private List<String> valueList;
            private List<Range> ranges;

            public String getValue() {
                return StringUtils.join(valueList, ",");
            }

            public String getSelectType() {
                return selectType;
            }

            public void setSelectType(String selectType) {
                this.selectType = selectType;
            }

            public List<String> getValueList() {
                return valueList;
            }

            public void setValueList(List<String> valueList) {
                this.valueList = valueList;
            }

            public List<Range> getRanges() {
                return ranges;
            }

            public void setRanges(List<Range> ranges) {
                this.ranges = ranges;
            }

            public static class Range implements Serializable {
                private String start;
                private String end;

                public String getStart() {
                    return start;
                }

                public void setStart(String start) {
                    this.start = start;
                }

                public String getEnd() {
                    return end;
                }

                public void setEnd(String end) {
                    this.end = end;
                }
            }
        }
    }
}
