/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.jdk.io.excel;

import com.xforceplus.bi.commons.jdk.io.excel.ExcelVersion;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader
implements Closeable {
    private Workbook workbook;

    public void read(String filePath, String suffix) {
        try {
            FileInputStream is = new FileInputStream(filePath);
            if (suffix.endsWith(ExcelVersion.V_2003.getExtension())) {
                this.workbook = new HSSFWorkbook((InputStream)is);
            } else if (suffix.endsWith(ExcelVersion.V_2007_ABOVE.getExtension())) {
                this.workbook = new XSSFWorkbook((InputStream)is);
            }
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6Excel\u5931\u8d25");
        }
    }

    public String getCellValue(Cell cell) {
        return this.getCellValue(cell, true);
    }

    public String getCellValue(Cell cell, boolean treatAsStr) {
        if (cell == null) {
            return "";
        }
        if (treatAsStr) {
            cell.setCellType(1);
        }
        if (cell.getCellType() == 4) {
            return String.valueOf(cell.getBooleanCellValue());
        }
        if (cell.getCellType() == 0) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return String.valueOf(cell.getStringCellValue());
    }

    public boolean isDate(Cell cell) {
        String dataFormatString = cell.getCellStyle().getDataFormatString();
        if (dataFormatString.contains("yyyy/mm;@")) {
            return true;
        }
        if (dataFormatString.contains("m/d/yy")) {
            return true;
        }
        if (dataFormatString.contains("yy/m/d")) {
            return true;
        }
        if (dataFormatString.contains("mm/dd/yy")) {
            return true;
        }
        if (dataFormatString.contains("dd-mmm-yy")) {
            return true;
        }
        return dataFormatString.contains("yyyy/m/d");
    }

    @Override
    public void close() throws IOException {
        if (this.workbook != null) {
            this.workbook.close();
            this.workbook = null;
        }
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelReader)) {
            return false;
        }
        ExcelReader other = (ExcelReader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Workbook this$workbook = this.getWorkbook();
        Workbook other$workbook = other.getWorkbook();
        return !(this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelReader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Workbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelReader(workbook=" + this.getWorkbook() + ")";
    }
}

