/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.jdk.io.excel;

import com.xforceplus.bi.commons.jdk.io.utils.IOUtil;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExcelWriter
implements Closeable {
    private SXSSFWorkbook workbook;
    private SXSSFSheet sheet;
    private SXSSFRow currentRow;
    AtomicInteger rowIndex = new AtomicInteger();
    private FileOutputStream outputStream;
    private String targetPath;
    private DecimalFormat dataFormat;

    public void setNumberFormat(String pattern) {
        this.dataFormat = new DecimalFormat(pattern);
    }

    public ExcelWriter(Integer fetchSize, String targetPath) throws FileNotFoundException {
        this.targetPath = targetPath;
        this.workbook = new SXSSFWorkbook(fetchSize.intValue());
        this.outputStream = IOUtil.getOut(targetPath);
    }

    public void createSheet() {
        this.rowIndex.set(0);
        SXSSFSheet sxssfSheet = this.workbook.createSheet();
        sxssfSheet.trackAllColumnsForAutoSizing();
        this.sheet = sxssfSheet;
    }

    @Deprecated
    public void writeHeads(String[] heads) throws IOException {
        this.createRow();
        for (int columnIndex = 0; columnIndex < heads.length; ++columnIndex) {
            this.createCell(this.currentRow, columnIndex, heads[columnIndex], null, false);
        }
    }

    public void writeHeads(String[] heads, CellStyle cellStyle) throws IOException {
        this.createRow();
        for (int columnIndex = 0; columnIndex < heads.length; ++columnIndex) {
            this.createCell(this.currentRow, columnIndex, heads[columnIndex], cellStyle, false);
        }
    }

    public void createRow() {
        this.currentRow = this.sheet.createRow(this.rowIndex.getAndIncrement());
    }

    public CellStyle createDefaultCellStyle() {
        return this.workbook.createCellStyle();
    }

    public CellStyle createNumberCellStyle(String numberFormat) {
        CellStyle style = this.workbook.createCellStyle();
        DataFormat format = this.workbook.createDataFormat();
        style.setDataFormat(format.getFormat(numberFormat));
        return style;
    }

    public void writeCell(int columnIndex, Object value, boolean needTransferToNumber, CellStyle cellStyle) {
        String resultValue = needTransferToNumber && this.dataFormat != null ? this.dataFormat.format(new BigDecimal(value.toString())) : (value == null ? "" : value.toString());
        this.createCell(this.currentRow, columnIndex, resultValue, cellStyle, needTransferToNumber);
    }

    public void flush() throws IOException {
        this.workbook.write((OutputStream)this.outputStream);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.outputStream);
        IOUtils.closeQuietly((Closeable)this.workbook);
    }

    private void createCell(SXSSFRow row, int cellNum, String value, CellStyle cellStyle, boolean needTransferToNumber) {
        SXSSFCell cell0 = row.createCell(cellNum);
        cell0.setCellStyle(cellStyle);
        if (needTransferToNumber) {
            cell0.setCellValue(Double.parseDouble(value));
        } else {
            cell0.setCellValue((RichTextString)new XSSFRichTextString(value));
        }
    }
}

