/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.bi.commons.integration.user.beans.UserInfo;
import com.xforceplus.bi.commons.integration.user.utils.RequestUserContext;
import com.xforceplus.bi.commons.log.BILogAction;
import com.xforceplus.bi.commons.log.BILogBean;
import io.swagger.annotations.ApiOperation;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.io.InputStreamSource;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RestController;

@Aspect
@Component
public class BILogAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ThreadLocal<Date> beginTimeThreadLocal = new NamedThreadLocal("ThreadLocal beginTime");
    private static final ThreadLocal<BILogBean> logThreadLocal = new NamedThreadLocal("ThreadLocal log");
    @Autowired(required=false)
    HttpServletRequest request;
    @Autowired
    private BILogAction biLogAction;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Pointcut(value="@annotation(io.swagger.annotations.ApiOperation)")
    public void biLog() {
    }

    @Before(value="biLog()")
    public void doBefore(JoinPoint joinPoint) throws InterruptedException {
        this.logger.info("\u8fdb\u5165\u65e5\u5fd7\u5207\u9762\u524d\u7f6e\u901a\u77e5!!");
        Date beginTime = new Date();
        beginTimeThreadLocal.set(beginTime);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f00\u59cb\u8ba1\u65f6: {}\u00a0 URI: {}", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(beginTime), (Object)this.request.getRequestURI());
        }
        this.initLog(joinPoint, beginTime);
    }

    private void initLog(JoinPoint joinPoint, Date beginTime) {
        BILogBean biLogBean = BILogAspect.createLog(joinPoint);
        String level = "info";
        String requestUri = this.request.getRequestURI();
        String method = this.request.getMethod();
        biLogBean.setLevel(level);
        biLogBean.setRemoteAddr(BILogAspect.getIpAddress(this.request));
        biLogBean.setRequestUri(requestUri);
        biLogBean.setMethod(method);
        biLogBean.setParams(this.getPramraString(joinPoint.getArgs()));
        biLogBean.setException("\u65e0\u5f02\u5e38!");
        UserInfo userInfo = RequestUserContext.get();
        biLogBean.setOperateDate(beginTime);
        biLogBean.setApplicationName(this.applicationName);
        if (userInfo != null) {
            biLogBean.setUserId(userInfo.getId());
            biLogBean.setUserName(userInfo.getUsername());
            biLogBean.setTenantCode(userInfo.getTenantCode());
            biLogBean.setAuthPlatForm(userInfo.getAuthSource() == null ? "" : userInfo.getAuthSource().getCode());
        }
        logThreadLocal.set(biLogBean);
    }

    private String getPramraString(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            Object item = args[i];
            if (!(item instanceof ServletResponse) && !(item instanceof HttpServletResponse) && !(item instanceof ServletRequest) && !(item instanceof HttpServletRequest) && !(item instanceof InputStreamSource)) continue;
            args[i] = null;
        }
        return JSONArray.toJSONString((Object)args);
    }

    @After(value="biLog()")
    public void doAfter(JoinPoint joinPoint) {
        BILogBean biLogBean;
        long beginTime = beginTimeThreadLocal.get().getTime();
        long endTime = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("\u8fdb\u5165\u65e5\u5fd7\u5207\u9762\u540e\u7f6e\u901a\u77e5!!");
            this.logger.debug("\u8ba1\u65f6\u7ed3\u675f\uff1a{}\u00a0 URI: {}\u00a0 \u8017\u65f6\uff1a {} \u6700\u5927\u5185\u5b58: {}m\u00a0 \u5df2\u5206\u914d\u5185\u5b58: {}m\u00a0 \u5df2\u5206\u914d\u5185\u5b58\u4e2d\u7684\u5269\u4f59\u7a7a\u95f4: {}m\u00a0 \u6700\u5927\u53ef\u7528\u5185\u5b58: {}m", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(endTime), this.request.getRequestURI(), endTime - beginTime, Runtime.getRuntime().maxMemory() / 1024L / 1024L, Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L, (Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory()) / 1024L / 1024L});
            this.logger.info("\u8bbe\u7f6e\u65e5\u5fd7\u4fe1\u606f\u5b58\u50a8\u5230\u8868\u4e2d!!");
        }
        if ((biLogBean = logThreadLocal.get()) != null) {
            biLogBean.setTimeout(new Date(endTime));
            logThreadLocal.set(biLogBean);
        }
    }

    @AfterReturning(returning="res", pointcut="biLog()")
    public void doAfterReturning(Object res) throws Throwable {
        BILogBean biLogBean;
        if (this.logger.isDebugEnabled()) {
            this.logger.info("==========\u8fd4\u56de\u53c2\u6570\u65e5\u5fd7=========");
            this.logger.info("\u8fd4\u56de\u63a5\u53e3\u54cd\u5e94\u53c2\u6570:" + JSONObject.toJSONString((Object)res));
            this.logger.info("==========\u66f4\u65b0\u65e5\u5fd7\u53c2\u6570=========");
        }
        if ((biLogBean = logThreadLocal.get()) != null) {
            biLogBean.setResultParams(res instanceof Serializable ? JSONObject.toJSONString((Object)res) : "");
            this.saveLogThread(biLogBean);
        }
    }

    @AfterThrowing(pointcut="biLog()", throwing="throwable")
    public void test(Throwable throwable) {
        BILogBean biLogBean;
        if (this.logger.isDebugEnabled()) {
            this.logger.info("\u8fdb\u5165\u65e5\u5fd7\u5207\u9762\u5f02\u5e38\u901a\u77e5!!");
            this.logger.info("\u5f02\u5e38\u4fe1\u606f:" + throwable.getMessage());
        }
        if ((biLogBean = logThreadLocal.get()) != null) {
            biLogBean.setLevel("error");
            biLogBean.setException(BILogAspect.getStackTrace(throwable));
            this.saveLogThread(biLogBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    public static BILogBean createLog(JoinPoint joinPoint) {
        BILogBean biLogBean = new BILogBean();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        String discription = apiOperation.value();
        biLogBean.setDescription(StringUtils.isEmpty((CharSequence)discription) ? "\u672a\u5b9a\u4e49" : discription);
        biLogBean.setTypes(BILogAspect.type(joinPoint.getTarget().getClass()));
        return biLogBean;
    }

    private static String type(Class c) {
        if (c == null) {
            return "Other";
        }
        if (c.getAnnotation(Controller.class) != null || c.getAnnotation(RestController.class) != null) {
            return Controller.class.getSimpleName() + ":" + c.getSimpleName();
        }
        if (c.getAnnotation(Service.class) != null) {
            return Service.class.getSimpleName() + ":" + c.getSimpleName();
        }
        return "Other:" + c.getSimpleName();
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public void saveLogThread(BILogBean BILogBean2) {
        this.biLogAction.recordLog(BILogBean2);
    }
}

