/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.log;

import com.xforceplus.bi.commons.log.BILogBean;
import com.xforceplus.bi.commons.log.dao.LogDao;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class LogSaveJob {
    @Autowired
    private LogDao logDao;
    @Autowired
    private RedissonClient redissonClient;

    @Scheduled(fixedDelay=60L)
    public void saveLog() throws IOException {
        ArrayList<BILogBean> logDtoList = new ArrayList<BILogBean>();
        RQueue rQueue = this.redissonClient.getQueue("xforce_bi:quene2");
        BILogBean biLogBean = (BILogBean)rQueue.poll();
        while (biLogBean != null) {
            logDtoList.add(biLogBean);
            if (logDtoList.size() >= 100) {
                this.logDao.insertLogRecord(logDtoList);
                logDtoList.clear();
            }
            biLogBean = (BILogBean)rQueue.poll();
        }
        if (logDtoList.size() > 0) {
            this.logDao.insertLogRecord(logDtoList);
            logDtoList.clear();
        }
    }
}

