package com.xforceplus.bi.commons.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObjectSummary;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;

public interface BiOssClient {

    /**
     * 获取OSS客户端
     *
     * @return
     */
    OSSClient getOssClient();

    /**
     * 释放OSS客户端
     *
     * @param ossClient
     */
    void release(OSSClient ossClient);

    /**
     * 列出文件列表
     *
     * @param fileName         文件名
     * @param lowerLimitMarker 最小文件名(字符串比较)
     * @param limit            返回数量限制
     * @return
     */
    List<OSSObjectSummary> listFiles(String fileName, String lowerLimitMarker, int limit);

    /**
     * 上传文件
     *
     * @param localPath      本地文件路径
     * @param targetFileName 生成在OSS中文件名
     * @return
     */
    void upload(String localPath, String targetFileName) throws FileNotFoundException;

    /**
     * @param fileNames 文件名列表
     * @return
     */
    void delete(List<String> fileNames);

    void deleteByPrefix(String pathExport);

    /**
     * 从OSS中读取输入流
     *
     * @param ossClient
     * @param filePath
     * @return
     */
    InputStream read(OSSClient ossClient, String filePath);

    /**
     * 询问文件存在
     *
     * @param filename
     * @return
     */
    boolean doesObjectExist(String filename);

    /**
     * 询问文件不存在
     *
     * @param filename
     * @return
     */
    boolean doesObjectNotExist(String filename);
}
