/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.bi.commons.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GenericResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.xforceplus.bi.commons.oss.BiOssClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BiOssClientImpl
implements BiOssClient {
    private static final Logger log = LoggerFactory.getLogger(BiOssClientImpl.class);
    private static final String OSS_ERROR_READ = "\u8bfb\u53d6OSS\u6587\u4ef6\u5931\u8d25";
    @Value(value="${xforce.bi-oss.endpoint}")
    private String endpoint;
    @Value(value="${xforce.bi-oss.access-key}")
    private String accessKey;
    @Value(value="${xforce.bi-oss.secure-key}")
    private String secureKey;
    @Value(value="${xforce.bi-oss.bucket}")
    private String bucket;

    @Override
    public OSSClient getOssClient() {
        return new OSSClient(this.endpoint, this.accessKey, this.secureKey);
    }

    @Override
    public void release(OSSClient ossClient) {
        if (ossClient != null) {
            try {
                ossClient.shutdown();
            }
            catch (Throwable thr) {
                log.warn("\u5173\u95edOSSClient\u5931\u8d25");
            }
        }
    }

    @Override
    public List<OSSObjectSummary> listFiles(String fileName, String lowerLimitMarker, int limit) {
        OSSClient ossClient = null;
        try {
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucket, fileName, lowerLimitMarker, null, Integer.valueOf(limit));
            ossClient = this.getOssClient();
            List list = ossClient.listObjects(listObjectsRequest).getObjectSummaries();
            this.release(ossClient);
            return list;
        }
        catch (Throwable thr) {
            try {
                throw thr;
            }
            catch (Throwable throwable) {
                this.release(ossClient);
                throw throwable;
            }
        }
    }

    @Override
    public void upload(String localPath, String targetFileName) throws FileNotFoundException {
        OSSClient ossClient = null;
        String resultMessage = null;
        try {
            ossClient = this.getOssClient();
            File file = new File(localPath);
            ObjectMetadata objectMeta = new ObjectMetadata();
            objectMeta.setContentLength(file.length());
            FileInputStream input = new FileInputStream(file);
            PutObjectResult result = ossClient.putObject(this.bucket, targetFileName, (InputStream)input);
            resultMessage = this.getResultMessage((GenericResult)result);
        }
        catch (Throwable thr) {
            log.error(resultMessage, thr);
            throw thr;
        }
        finally {
            this.release(ossClient);
        }
    }

    private String getResultMessage(GenericResult result) {
        if (result == null) {
            return null;
        }
        ResponseMessage response = result.getResponse();
        if (response == null) {
            return null;
        }
        try {
            int c;
            InputStream content = response.getContent();
            StringBuilder line = new StringBuilder(256);
            while ((c = content.read()) != -1) {
                line.append((char)c);
            }
            return line.toString();
        }
        catch (IOException e) {
            log.warn("\u5206\u6790OSS\u8fd4\u56de\u5931\u8d25");
            return null;
        }
    }

    @Override
    public void delete(List<String> fileNames) {
        if (CollectionUtils.isEmpty(fileNames)) {
            return;
        }
        OSSClient ossClient = null;
        String resultMessage = null;
        try {
            ossClient = this.getOssClient();
            DeleteObjectsResult result = ossClient.deleteObjects(new DeleteObjectsRequest(this.bucket).withKeys(fileNames));
            resultMessage = this.getResultMessage((GenericResult)result);
        }
        catch (Throwable thr) {
            log.error(resultMessage, thr);
            throw thr;
        }
        finally {
            this.release(ossClient);
        }
    }

    @Override
    public void deleteByPrefix(String prefix) {
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            log.warn("\u5371\u9669\u64cd\u4f5c,\u4e0d\u80fd\u5220\u9664\u6839");
            return;
        }
        OSSClient ossClient = null;
        String nextMarker = null;
        ObjectListing objectListing = null;
        try {
            do {
                ListObjectsRequest listObjectsRequest;
                if ((objectListing = (ossClient = this.getOssClient()).listObjects(listObjectsRequest = new ListObjectsRequest(this.bucket).withPrefix(prefix).withMarker(nextMarker))).getObjectSummaries().size() > 0) {
                    ArrayList<String> keys = new ArrayList<String>();
                    for (OSSObjectSummary s : objectListing.getObjectSummaries()) {
                        keys.add(s.getKey());
                    }
                    DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucket).withKeys(keys);
                    ossClient.deleteObjects(deleteObjectsRequest);
                }
                nextMarker = objectListing.getNextMarker();
            } while (objectListing.isTruncated());
        }
        catch (Throwable thr) {
            throw thr;
        }
        finally {
            this.release(ossClient);
        }
    }

    @Override
    public InputStream read(OSSClient ossClient, String filePath) {
        OSSObject ossObject = ossClient.getObject(this.bucket, filePath);
        return ossObject.getObjectContent();
    }

    @Override
    public boolean doesObjectExist(String filename) {
        OSSClient ossClient = null;
        try {
            ossClient = this.getOssClient();
            boolean bl = ossClient.doesObjectExist(this.bucket, filename);
            return bl;
        }
        catch (Throwable thr) {
            throw thr;
        }
        finally {
            this.release(ossClient);
        }
    }

    @Override
    public boolean doesObjectNotExist(String filename) {
        return !this.doesObjectExist(filename);
    }
}

