package com.xforceplus.bi.commons.resourcecode.dao;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

@Mapper
public interface PermissionLimitedObjectsDao {
    @Select({
            "<script>",
            "SELECT DISTINCT",
            "dtl.table_real_name ",
            "FROM bi_worker_05_dataset_detail dtl",
            "LEFT JOIN bi_worker_04_dataset_mst mst ON mst.id = dtl.mst_id",
            "LEFT JOIN bi_resource r ON r.recource_code = mst.resource_code",
            "WHERE mst.belong_tenant = #{belongTenant}",
            "AND dtl.datasource_instance_id = #{datasourceInstanceId}",
            "AND mst.resource_code IN",
            "<foreach collection='resourceCodes' item='item' open='(' separator=',' close=')'>",
            "#{item}",
            "</foreach>",
            "</script>"
    })
    List<String> permissionLimitedTables(@Param("belongTenant") String belongTenant,
                                         @Param("datasourceInstanceId") String datasourceInstanceId,
                                         @Param("resourceCodes") Set<String> resourceCodes);
}
