package com.xforceplus.bi.commons.resourcecode.dao;


import org.apache.ibatis.annotations.*;

@Mapper
public interface ResourceCodeDao {
    /**
     * 新增资源码
     *
     * @param code
     * @param name
     * @param tenantId
     */
    @Insert("INSERT INTO `bi_resource`(`recource_code`, `resource_name`, `tenant_id`, `status`) VALUES (#{code}, #{name}, #{tenantId},#{status});")
    void insertResourceCode(@Param("code") String code, @Param("name") String name, @Param("tenantId") String tenantId, @Param("status") boolean status);

    /**
     * 修改资源码名称
     *
     * @param code
     * @param name
     * @param tenantId
     * @return
     */
    @Update("UPDATE `bi_resource` SET  `resource_name` = #{name} WHERE `recource_code` = #{code} AND `tenant_id` = #{tenantId};")
    long updateResourceCodeName(@Param("code") String code, @Param("name") String name, @Param("tenantId") String tenantId);

    /**
     * 删除资源码
     *
     * @param code
     * @param tenantId
     * @return
     */
    @Delete("DELETE FROM `bi_resource` WHERE `recource_code` = #{code} AND `tenant_id` = #{tenantId};")
    long deleteResourceCode(@Param("code") String code, @Param("tenantId") String tenantId);

    /**
     * 修改资源码状态
     *
     * @param code
     * @param status
     * @param tenantId
     * @return
     */
    @Update("UPDATE `bi_resource` SET  `status` = #{status} WHERE `recource_code` = #{code} AND `tenant_id` = #{tenantId};")
    long activeResourceCode(@Param("code") String code, @Param("tenantId") String tenantId, @Param("status") boolean status);

    /**
     * 查询资源码是否存在,返回null说明不存在,返回1存在
     *
     * @param resourceCode
     * @return
     */
    @Select("select 1 from bi_resource where recource_code = #{resourceCode} limit 1;")
    Integer resourceCodeExists(@Param("resourceCode") String resourceCode);

    /**
     * 根据集团和资源码名称,找出资源码
     *
     * @param resourceName 资源码名称
     * @param tenantId     集团
     * @return
     */
    @Select("select recource_code from bi_resource where resource_name = #{resourceName} and tenant_id = #{tenantId};")
    String findResourceCode(@Param("resourceName") String resourceName, @Param("tenantId") String tenantId);
}
