package com.xforceplus.bi.commons.resourcecode.service;

public interface ResourceCodeService {
    /**
     * 插入资源码
     *
     * @param resourceCode 资源码code
     * @param resourceName 资源码名称
     */
    void insertResourceCode(String resourceCode, String resourceName);

    /**
     * 删除资源码
     *
     * @param resourceCode 资源码code
     */
    void deleteResourceCode(String resourceCode);

    /**
     * 资源码唯一性校验
     *
     * @param resourceCode 资源码
     */
    void validateResourceCodeUnique(String resourceCode);

    /**
     * 保存资源码
     *
     * @param newResourceCode 新资源码
     * @param oldResourceCode 旧资源码
     * @param resourceName    资源码名称
     */
    void saveResourceCode(String newResourceCode, String oldResourceCode, String resourceName);
}
